/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.url;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.url.IAuthority;
import net.anwiba.commons.reference.url.IHost;
import net.anwiba.commons.reference.url.IUrl;

public class Url
implements IUrl {
    private final List<String> scheme;
    private final List<String> path;
    private final IParameters parameters;
    private final String fragment;
    private final IAuthority authority;
    private static final Set<String> commonEscapeSymbols = Set.of("%20", "%3C", "%3E", "%23", "%25", "%2B", "%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60", "%3B", "%2F", "%3F", "%3A", "%40", "%3D", "%26", "%24");

    public Url(List<String> scheme, IAuthority authority, List<String> path, List<IParameter> parameters, String fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.parameters = new ParametersBuilder().add(parameters).build();
        this.fragment = fragment;
    }

    @Override
    public List<String> getScheme() {
        return this.scheme;
    }

    @Override
    public IAuthentication getAuthentication() {
        return (IAuthentication)Optional.of((Object)this.authority).convert(a -> a.getAuthentication()).get();
    }

    @Override
    public IHost getHost() {
        return (IHost)Optional.of((Object)this.authority).convert(a -> a.getHost()).get();
    }

    @Override
    public List<String> getPath() {
        return this.path;
    }

    @Override
    public IParameters getQuery() {
        return this.parameters;
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.join((CharSequence)":", this.scheme));
        builder.append("://");
        if (this.authority != null) {
            IHost host;
            IAuthentication authentication = this.getAuthentication();
            if (authentication != null) {
                builder.append(authentication.getUsername());
                builder.append(":");
                builder.append(authentication.getPassword());
                builder.append("@");
            }
            if ((host = this.getHost()) != null) {
                builder.append(host.getName());
                if (host.getPort() > -1) {
                    builder.append(":");
                    builder.append(host.getPort());
                }
            }
        }
        if (this.path.isEmpty()) {
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(this.getQueryString());
            } else {
                builder.append("/");
            }
        } else {
            builder.append(String.join((CharSequence)"", this.path));
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(this.getQueryString());
            }
        }
        if (this.fragment != null) {
            builder.append("#");
            builder.append(this.fragment);
        }
        return builder.toString();
    }

    @Override
    public String getHostname() {
        return (String)Optional.of((Object)this.authority).convert(a -> a.getHost()).convert(h -> h.getName()).get();
    }

    @Override
    public int getPort() {
        return (Integer)Optional.of((Object)this.authority).convert(a -> a.getHost()).convert(h -> h.getPort()).getOr(() -> -1);
    }

    @Override
    public String getPathString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.join((CharSequence)"", this.path));
        return builder.toString();
    }

    @Override
    public String getUserName() {
        return (String)Optional.of((Object)this.authority).convert(a -> a.getAuthentication()).convert(a -> a.getUsername()).get();
    }

    @Override
    public String getPassword() {
        return (String)Optional.of((Object)this.authority).convert(a -> a.getAuthentication()).convert(a -> a.getPassword()).get();
    }

    @Override
    public String encoded() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.join((CharSequence)":", this.scheme));
        builder.append("://");
        if (this.authority != null) {
            IHost host;
            IAuthentication authentication = this.getAuthentication();
            if (authentication != null) {
                builder.append(authentication.getUsername());
                builder.append(":");
                builder.append(authentication.getPassword());
                builder.append("@");
            }
            if ((host = this.getHost()) != null) {
                builder.append(host.getName());
                if (host.getPort() > -1) {
                    builder.append(":");
                    builder.append(host.getPort());
                }
            }
        }
        if (this.path.isEmpty()) {
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(this.getEncodedQueryString());
            } else {
                builder.append("/");
            }
        } else {
            builder.append(String.join((CharSequence)"", this.path.stream().map(p -> this.encodePath((String)p)).collect(Collectors.toList())));
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(this.getEncodedQueryString());
            }
        }
        if (this.fragment != null) {
            builder.append("#");
            builder.append(this.fragment);
        }
        return builder.toString();
    }

    private String encodePath(String string) {
        try {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (this.isCommonEscapeSequence(string, c, i)) {
                    builder.append(c);
                    continue;
                }
                if (c != '/') {
                    this.encode(builder, c);
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException exception) {
            return string;
        }
    }

    private String encode(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (this.isCommonEscapeSequence(string, c, i)) {
                    builder.append(c);
                    continue;
                }
                this.encode(builder, c);
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException exception) {
            return string;
        }
    }

    protected boolean isCommonEscapeSequence(String string, char c, int index) {
        return c == '%' && index + 2 < string.length() && commonEscapeSymbols.contains(string.subSequence(index, index + 3));
    }

    private void encode(StringBuilder builder, char c) throws UnsupportedEncodingException {
        if (c != ' ') {
            builder.append(URLEncoder.encode(String.valueOf(c), "UTF-8"));
        } else {
            builder.append("%20");
        }
    }

    @Override
    public String decoded() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.join((CharSequence)":", this.scheme));
        if (Objects.equals(this.scheme, List.of("file"))) {
            builder.append(":/");
        } else {
            builder.append("://");
        }
        if (this.authority != null) {
            IHost host;
            IAuthentication authentication = this.getAuthentication();
            if (authentication != null) {
                builder.append(authentication.getUsername());
                builder.append(":");
                builder.append(authentication.getPassword());
                builder.append("@");
            }
            if ((host = this.getHost()) != null) {
                builder.append(host.getName());
                if (host.getPort() > -1) {
                    builder.append(":");
                    builder.append(host.getPort());
                }
            }
        }
        if (this.path.isEmpty()) {
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(this.getQueryString());
            } else {
                builder.append("/");
            }
        } else {
            builder.append(String.join((CharSequence)"", this.path.stream().map(p -> p).collect(Collectors.toList())));
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(this.getQueryString());
            }
        }
        if (this.fragment != null) {
            builder.append("#");
            builder.append(this.fragment);
        }
        return builder.toString();
    }

    private String getEncodedQueryString() {
        return String.join((CharSequence)"&", Streams.of((Iterable)this.parameters.parameters()).convert(p -> this.encode(p.getName()) + "=" + this.encode(p.getValue())).asList());
    }

    private String getQueryString() {
        return String.join((CharSequence)"&", Streams.of((Iterable)this.parameters.parameters()).convert(p -> p.getName() + "=" + p.getValue()).asList());
    }
}

