/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.url;

import java.util.List;
import net.anwiba.commons.lang.parameter.IParameter;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.Parameter;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.url.Authentication;
import net.anwiba.commons.reference.url.Authority;
import net.anwiba.commons.reference.url.Host;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.url.IHost;
import net.anwiba.commons.reference.url.IUrl;
import net.anwiba.commons.reference.url.Url;

public class UrlUtilities {
    public static IUrl decode(IUrl url) {
        return new Url(UrlUtilities.decode(url.getScheme()), new Authority(UrlUtilities.decode(url.getAuthentication()), UrlUtilities.decode(url.getHost())), UrlUtilities.decode(url.getPath()), UrlUtilities.decode(url.getQuery()), UrlUtilities.decode(url.getFragment()));
    }

    private static List<IParameter> decode(IParameters parameters) {
        return Streams.of((Iterable)parameters.parameters()).convert(p -> UrlUtilities.decode(p)).asList();
    }

    private static IParameter decode(IParameter parameter) {
        return Parameter.of((String)UrlUtilities.decode(parameter.getName()), (String)UrlUtilities.decode(parameter.getValue()));
    }

    private static IAuthentication decode(IAuthentication authentication) {
        return new Authentication(UrlUtilities.decode(authentication.getUsername()), UrlUtilities.decode(authentication.getPassword()));
    }

    private static List<String> decode(List<String> list) {
        return list.stream().map(v -> UrlUtilities.decode(v)).toList();
    }

    private static String decode(String v) {
        return v.replace(" ", "%20");
    }

    public static IUrl encode(IUrl url) {
        return new Url(UrlUtilities.encode(url.getScheme()), new Authority(UrlUtilities.encode(url.getAuthentication()), UrlUtilities.encode(url.getHost())), UrlUtilities.encode(url.getPath()), UrlUtilities.encode(url.getQuery()), UrlUtilities.encode(url.getFragment()));
    }

    private static IHost decode(IHost host) {
        return new Host(UrlUtilities.decode(host.getName()), host.getPort());
    }

    private static IHost encode(IHost host) {
        return new Host(UrlUtilities.encode(host.getName()), host.getPort());
    }

    private static List<IParameter> encode(IParameters parameters) {
        return Streams.of((Iterable)parameters.parameters()).convert(p -> UrlUtilities.encode(p)).asList();
    }

    private static IParameter encode(IParameter parameter) {
        return Parameter.of((String)UrlUtilities.encode(parameter.getName()), (String)UrlUtilities.encode(parameter.getValue()));
    }

    private static IAuthentication encode(IAuthentication authentication) {
        return new Authentication(UrlUtilities.decode(authentication.getUsername()), UrlUtilities.decode(authentication.getPassword()));
    }

    private static List<String> encode(List<String> list) {
        return list.stream().map(v -> UrlUtilities.decode(v)).toList();
    }

    private static String encode(String v) {
        return v.replace("%20", " ");
    }
}

