/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.url.builder;

import net.anwiba.commons.reference.url.Authority;
import net.anwiba.commons.reference.url.IAuthentication;
import net.anwiba.commons.reference.url.IAuthority;
import net.anwiba.commons.reference.url.IHost;
import net.anwiba.commons.reference.url.builder.AuthenticationBuilder;
import net.anwiba.commons.reference.url.builder.HostBuilder;

public class AuthorityBuilder {
    private String username;
    private String password;
    private String hostName;
    private Integer port;

    public IAuthority build() {
        IAuthentication authentication = new AuthenticationBuilder().setUsername(this.username).setPassword(this.password).build();
        IHost host = new HostBuilder().setHostName(this.hostName).setPort(this.port).build();
        return new Authority(authentication, host);
    }

    public AuthorityBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public AuthorityBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public AuthorityBuilder setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public AuthorityBuilder setPort(Integer port) {
        this.port = port;
        return this;
    }
}

