/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.parameter.IParameters;
import net.anwiba.commons.lang.parameter.Parameters;
import net.anwiba.commons.lang.parameter.ParametersBuilder;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.utilities.IContentType;
import net.anwiba.commons.reference.utilities.IPrimaryType;
import net.anwiba.commons.reference.utilities.ISecondaryType;
import net.anwiba.commons.reference.utilities.PrimaryType;
import net.anwiba.commons.reference.utilities.SecondaryType;
import net.anwiba.commons.reference.utilities.StringUtilities;
import net.anwiba.commons.version.IVersion;
import net.anwiba.commons.version.Version;
import net.anwiba.commons.version.VersionUtilities;

public final class ContentType
implements IContentType {
    private static final Set<ContentType> types = new LinkedHashSet<ContentType>();
    public static final IContentType TEXT_PLAIN = ContentType.add(PrimaryType.TEXT, SecondaryType.PLAIN, "txt");
    public static final IContentType TEXT_XML = ContentType.add(PrimaryType.TEXT, SecondaryType.XML, "xml");
    public static final IContentType TEXT_HTML = ContentType.add(PrimaryType.TEXT, SecondaryType.HTML, "html", "htm", "shtm");
    public static final IContentType TEXT_CSV = ContentType.add(PrimaryType.TEXT, SecondaryType.CSV, "csv");
    public static final IContentType APPLICATION_OCTET_STREAM = ContentType.add(PrimaryType.APPLICATION, SecondaryType.OCTET_STREAM, new String[0]);
    public static final IContentType APPLICATION_FORM_URLENCODED = ContentType.add(PrimaryType.APPLICATION, SecondaryType.FORM_URLENCODED, new String[0]);
    public static final IContentType APPLICATION_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.XML, "xml");
    public static final IContentType APPLICATION_XHTML_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.XHTML_XML, "xhtml", "xml");
    public static final IContentType APPLICATION_GML_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.GML_XML, "gml", "xml");
    public static final IContentType APPLICATION_OGC_SE_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.OGC_SE_XML, "se", "se_xml", "xml");
    public static final IContentType APPLICATION_OGC_SLD_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.OGC_SLD_XML, "sld", "xml");
    public static final IContentType APPLICATION_OGC_WFS_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.OGC_WFS_XML, "xml");
    public static final IContentType APPLICATION_OGC_WMTS_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.OGC_WMTS_XML, "xml");
    public static final IContentType APPLICATION_OGC_WMS_XML = ContentType.add(PrimaryType.APPLICATION, SecondaryType.OGC_WMS_XML, "xml");
    public static final IContentType APPLICATION_JSON = ContentType.add(PrimaryType.APPLICATION, SecondaryType.JSON, "json");
    public static final IContentType APPLICATION_GEOJSON = ContentType.add(PrimaryType.APPLICATION, SecondaryType.GEOJSON, "geojson", "json");
    public static final IContentType APPLICATION_GPX = ContentType.add(PrimaryType.APPLICATION, SecondaryType.GPX, "gpx");
    public static final IContentType APPLICATION_PDF = ContentType.add(PrimaryType.APPLICATION, SecondaryType.PDF, "pdf");
    public static final IContentType APPLICATION_ZIP = ContentType.add(PrimaryType.APPLICATION, SecondaryType.ZIP, "zip");
    public static final IContentType IMAGE_BMP = ContentType.add(PrimaryType.IMAGE, SecondaryType.BMP, "bmp");
    public static final IContentType IMAGE_GIF = ContentType.add(PrimaryType.IMAGE, SecondaryType.GIF, "gif");
    public static final IContentType IMAGE_JPEG = ContentType.add(PrimaryType.IMAGE, SecondaryType.JPEG, "jpg", "jpeg", "jpe");
    public static final IContentType IMAGE_TIFF = ContentType.add(PrimaryType.IMAGE, SecondaryType.TIFF, "tiff", "tif");
    public static final IContentType IMAGE_PNG = ContentType.add(PrimaryType.IMAGE, SecondaryType.PNG, "png", "png32");
    public static final IContentType IMAGE_PNG32 = ContentType.add(PrimaryType.IMAGE, SecondaryType.PNG32, "png32");
    public static final IContentType IMAGE_SVG = ContentType.add(PrimaryType.IMAGE, SecondaryType.SVG, "svg");
    public static final IContentType X_GIS_SHAPEFILE = ContentType.add(PrimaryType.X_GIS, SecondaryType.X_SHAPEFILE, "shp");
    private static final String SEPARATOR = "/";
    private final IPrimaryType primaryType;
    private final ISecondaryType secondaryType;
    private final String[] fileExtensions;
    private final IParameters parameters;
    private final IVersion version;
    private static final Set<String> acceptedParameterNames = Set.of("subtype", "version");

    public static IOptional<ContentType, RuntimeException> getByValue(String contentType) {
        try {
            IContentType type = Parser.parse(contentType);
            return Streams.of(types).first(value -> value.toString().equals(type.getPrimaryType() + SEPARATOR + type.getSecondaryType() + ContentType.toString((IVersion)type.getVersion().get()) + ContentType.toString(ContentType.filter(type.getParameters()))));
        }
        catch (CreationException exception) {
            return Optional.empty();
        }
    }

    public static IOptional<IContentType, RuntimeException> getByFileExtension(String extension) {
        return Streams.of(types).filter(type -> type.hasFileExtension(extension)).first().instanceOf(IContentType.class);
    }

    public static IOptional<IContentType, CreationException> parse(String contentType) {
        if (contentType == null) {
            return Optional.empty(CreationException.class);
        }
        try {
            return Optional.of(CreationException.class, (Object)Parser.parse(contentType));
        }
        catch (CreationException exception) {
            return Optional.failed(CreationException.class, (Exception)((Object)exception));
        }
    }

    public static IOptional<IContentType, RuntimeException> from(String contentType) {
        try {
            if (contentType == null) {
                return Optional.empty();
            }
            IContentType type = Parser.parse(contentType);
            return ContentType.search(type);
        }
        catch (CreationException exception) {
            return Optional.empty();
        }
    }

    private static IOptional<IContentType, RuntimeException> search(IContentType type) {
        return Optional.of((Object)ContentType.from(type.getPrimaryType().toString(), type.getSecondaryType().toString(), (IVersion)type.getVersion().get(), ContentType.filter(type.getParameters())));
    }

    public static IContentType from(String primaryType, String subType) {
        return ContentType.from(primaryType, subType, null, (IParameters)Parameters.empty());
    }

    public static IContentType from(String primaryType, String subType, IVersion version, IParameters parameters) {
        return (IContentType)Streams.of(types).first(type -> type.toString().equals(primaryType + SEPARATOR + subType + ContentType.toString(parameters))).instanceOf(IContentType.class).getOr(() -> ContentType.create(primaryType, subType, version, parameters));
    }

    private static IContentType create(String primaryType, String subType, IVersion version, IParameters parameters) {
        return new ContentType((IPrimaryType)new PrimaryType(primaryType), (ISecondaryType)new SecondaryType(subType), version, parameters, new String[0]);
    }

    private static final IContentType add(IPrimaryType primaryType, ISecondaryType secondaryType, String ... fileExtensions) {
        ContentType type = new ContentType(primaryType, secondaryType, fileExtensions);
        types.add(type);
        return type;
    }

    ContentType(IPrimaryType primaryType, ISecondaryType secondaryType, String ... fileExtensions) {
        this(primaryType, secondaryType, null, (IParameters)Parameters.empty(), fileExtensions);
    }

    ContentType(IPrimaryType primaryType, ISecondaryType secondaryType, IVersion version, IParameters parameters, String ... fileExtensions) {
        String[] stringArray;
        this.primaryType = primaryType;
        this.secondaryType = secondaryType;
        this.version = version;
        this.parameters = parameters;
        if (fileExtensions.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = fileExtensions;
        }
        this.fileExtensions = stringArray;
    }

    @Override
    public String getName() {
        return this.primaryType + SEPARATOR + this.secondaryType;
    }

    @Override
    public IPrimaryType getPrimaryType() {
        return this.primaryType;
    }

    @Override
    public ISecondaryType getSecondaryType() {
        return this.secondaryType;
    }

    @Override
    public IOptional<IVersion, RuntimeException> getVersion() {
        return Optional.of((Object)this.version);
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    public IOptional<String, RuntimeException> getDefaultFileExtension() {
        return this.fileExtensions.length > 0 ? Optional.of((Object)this.fileExtensions[0]) : Optional.empty();
    }

    public List<String> getFileExtensions() {
        return List.of(this.fileExtensions);
    }

    public boolean hasFileExtension(String extension) {
        if (extension == null) {
            return false;
        }
        return Streams.of((Object[])this.fileExtensions).first(type -> type.equalsIgnoreCase(extension)).isAccepted();
    }

    public static IOptional<String, RuntimeException> getDefaultFileExtension(IContentType contentType) {
        IOptional<IContentType, RuntimeException> optional = ContentType.search(contentType);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        return ((ContentType)optional.get()).getDefaultFileExtension();
    }

    public static List<String> getFileExtensions(IContentType contentType) {
        IOptional<IContentType, RuntimeException> optional = ContentType.search(contentType);
        if (optional.isEmpty()) {
            return List.of();
        }
        return ((ContentType)optional.get()).getFileExtensions();
    }

    public static boolean hasFileExtension(IContentType contentType, String extension) {
        IOptional<IContentType, RuntimeException> optional = ContentType.search(contentType);
        if (optional.isEmpty()) {
            return false;
        }
        return ((ContentType)optional.get()).hasFileExtension(extension);
    }

    public String toString() {
        return this.primaryType + SEPARATOR + this.secondaryType + ContentType.toString(this.version) + ContentType.toString(this.parameters);
    }

    static String toString(IParameters parameters) {
        if (parameters.isEmpty()) {
            return "";
        }
        return "; " + String.join((CharSequence)"; ", parameters.stream().convert(p -> p.toString()).asList());
    }

    static String toString(IVersion version) {
        if (version == null) {
            return "";
        }
        return SEPARATOR + VersionUtilities.getTextShort((IVersion)version);
    }

    static IParameters filter(IParameters parameters) {
        ParametersBuilder builder = Parameters.builder();
        parameters.toSortedByName().toLowerCase().stream().filter(p -> acceptedParameterNames.contains(p.getName().toLowerCase())).foreach(p -> builder.add(p.getName().toLowerCase(), p.getValue()));
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.primaryType, this.secondaryType, this.version, this.parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IContentType)) {
            return false;
        }
        IContentType other = (IContentType)obj;
        return Objects.equals(this.primaryType, other.getPrimaryType()) && Objects.equals(this.secondaryType, other.getSecondaryType()) && Objects.equals(this.version, other.getVersion().get()) && Objects.equals(this.parameters, other.getParameters());
    }

    private static class Parser {
        private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

        private Parser() {
        }

        static IContentType parse(String contentType) throws CreationException {
            String primaryType = "";
            String subType = "";
            String version = "";
            String parametername = "";
            String parametervalue = "";
            State state = State.primary;
            StringBuilder stringBuilder = new StringBuilder();
            ParametersBuilder parameters = new ParametersBuilder();
            block42: for (char c : contentType.toCharArray()) {
                switch (c) {
                    case ' ': {
                        switch (state) {
                            case primary: {
                                throw new CreationException("Primary type is invalid.");
                            }
                            case sub: {
                                throw new CreationException("Sub type is invalid.");
                            }
                            case version: {
                                throw new CreationException("version is invalid.");
                            }
                        }
                        stringBuilder.append(c);
                        continue block42;
                    }
                    case '/': {
                        switch (state) {
                            case primary: {
                                primaryType = stringBuilder.toString();
                                stringBuilder = new StringBuilder();
                                state = State.sub;
                                continue block42;
                            }
                            case sub: {
                                subType = stringBuilder.toString();
                                stringBuilder = new StringBuilder();
                                state = State.version;
                                continue block42;
                            }
                            case version: {
                                throw new CreationException("version is invalid.");
                            }
                        }
                        stringBuilder.append(c);
                        continue block42;
                    }
                    case ';': {
                        switch (state) {
                            case primary: {
                                throw new CreationException("Primary type is invalid.");
                            }
                            case sub: {
                                subType = stringBuilder.toString();
                                stringBuilder = new StringBuilder();
                                state = State.parametername;
                                continue block42;
                            }
                            case version: {
                                version = stringBuilder.toString();
                                stringBuilder = new StringBuilder();
                                state = State.parametername;
                                continue block42;
                            }
                            case parametername: {
                                throw new CreationException("Parameter name is invalid.");
                            }
                            case parametervalue: {
                                parametervalue = stringBuilder.toString();
                                stringBuilder = new StringBuilder();
                                state = State.parametername;
                                parameters.add(parametername, parametervalue);
                                continue block42;
                            }
                        }
                    }
                    case '=': {
                        switch (state) {
                            case primary: {
                                throw new CreationException("Sub type is invalid.");
                            }
                            case sub: {
                                throw new CreationException("Primary type is invalid.");
                            }
                            case version: {
                                throw new CreationException("version is invalid.");
                            }
                            case parametername: {
                                parametername = stringBuilder.toString();
                                stringBuilder = new StringBuilder();
                                state = State.parametervalue;
                                continue block42;
                            }
                            case parametervalue: {
                                throw new CreationException("Parameter name is invalid.");
                            }
                        }
                    }
                    default: {
                        switch (state) {
                            case primary: {
                                if (!Parser.isTokenChar(c)) {
                                    throw new CreationException("Unable to find a sub type.");
                                }
                                stringBuilder.append(c);
                                continue block42;
                            }
                            case sub: {
                                if (!Parser.isTokenChar(c)) {
                                    throw new CreationException("Sub type is invalid.");
                                }
                                stringBuilder.append(c);
                                continue block42;
                            }
                            case version: {
                                if (!Parser.isVersionChar(c)) {
                                    throw new CreationException("Sub type is invalid.");
                                }
                                stringBuilder.append(c);
                                continue block42;
                            }
                        }
                        stringBuilder.append(c);
                        continue block42;
                    }
                }
            }
            switch (state) {
                case primary: {
                    throw new CreationException("Primary type is invalid.");
                }
                case sub: {
                    subType = stringBuilder.toString();
                    break;
                }
                case version: {
                    version = stringBuilder.toString();
                }
                case parametername: {
                    if (stringBuilder.toString().isEmpty()) break;
                    throw new CreationException("Missing parameter value.");
                }
                case parametervalue: {
                    parametervalue = stringBuilder.toString();
                    parameters.add(parametername, parametervalue);
                }
            }
            if (primaryType.isEmpty()) {
                throw new CreationException("Primary type is invalid.");
            }
            if (subType.isEmpty()) {
                throw new CreationException("Sub type is invalid.");
            }
            return ContentType.create(primaryType, subType, StringUtilities.isNullOrEmpty(version) ? null : Version.of((String)version), parameters.build());
        }

        private static boolean isTokenChar(char c) {
            return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
        }

        private static boolean isVersionChar(char c) {
            return Character.isDigit(c) || '.' == c;
        }
    }

    private static enum State {
        primary,
        sub,
        version,
        parametername,
        parametervalue;

    }
}

