/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IConverter;

public class FileIterableFactory {
    public <T> Iterable<T> create(final IApplicable<File> applicable, final IConverter<File, T, RuntimeException> converter, final File file) {
        final FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (Files.isSymbolicLink(file.toPath())) {
                    return false;
                }
                return pathname.isDirectory() || applicable.isApplicable((Object)pathname);
            }
        };
        final Stack<File> files = new Stack<File>();
        files.add(file);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T next = null;

                    @Override
                    public T next() {
                        try {
                            if (this.next == null && !this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object t = this.next;
                            return t;
                        }
                        finally {
                            this.next = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (!files.isEmpty()) {
                            File nextFile = (File)files.pop();
                            if (nextFile.isDirectory()) {
                                File[] childFiles;
                                for (File childFile : childFiles = nextFile.listFiles(filter)) {
                                    files.add(childFile);
                                }
                                continue;
                            }
                            if (!applicable.isApplicable((Object)nextFile)) continue;
                            this.next = converter.convert((Object)nextFile);
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }
}

