/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.anwiba.commons.lang.exception.Throwables;
import net.anwiba.commons.lang.functional.IBlock;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class IoUtilities {
    private static final int BUFFER_SIZE = 4096;
    private static ILogger logger = Logging.getLogger((String)IoUtilities.class.getName());

    public static ByteArrayInputStream copy(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IoUtilities.pipe(inputStream, outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        IoUtilities.pipe(in, out, 4096);
    }

    public static void pipe(InputStream in, OutputStream out, int bufferSize) throws IOException {
        IoUtilities.pipe(in, out, bufferSize, -1L);
    }

    public static void pipe(InputStream in, OutputStream out, int bufferSize, long numberOfBytes) throws IOException {
        int numChars;
        int arraysize = numberOfBytes > -1L && (long)bufferSize > numberOfBytes ? (int)numberOfBytes : bufferSize;
        byte[] buffer = new byte[arraysize];
        long readed = 0L;
        while ((numChars = in.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
            if (numberOfBytes <= -1L || (readed += (long)numChars) + (long)bufferSize <= numberOfBytes) continue;
            buffer = new byte[(int)(numberOfBytes - readed)];
        }
    }

    public static void pipe(File sourceFile, File targetFile) throws IOException, FileNotFoundException {
        try (FileInputStream inputStream = new FileInputStream(sourceFile);
             FileOutputStream outputStream = new FileOutputStream(targetFile);){
            IoUtilities.pipe((InputStream)inputStream, outputStream);
        }
    }

    public static void pipe(Readable reader, Writer writer) throws IOException {
        IoUtilities.pipe(reader, writer, 4096);
    }

    public static void pipe(Readable in, Writer out, int bufferSize) throws IOException {
        CharBuffer buffer = CharBuffer.allocate(bufferSize);
        while (in.read(buffer) > 0) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                char c = buffer.get();
                out.append(c);
            }
            out.flush();
            buffer.clear();
        }
    }

    public static void pipe(Readable in, Writer out, int bufferSize, long numberOfCharacters) throws IOException {
        int numChars;
        CharBuffer buffer = CharBuffer.allocate(bufferSize);
        long readed = 0L;
        while ((numChars = in.read(buffer)) > 0) {
            readed += (long)numChars;
            buffer.flip();
            while (buffer.hasRemaining()) {
                char c = buffer.get();
                out.append(c);
            }
            out.flush();
            if (numberOfCharacters > -1L && readed + (long)bufferSize > numberOfCharacters) {
                buffer = CharBuffer.allocate((int)(numberOfCharacters - readed));
            }
            buffer.clear();
        }
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        IoUtilities.pipe(reader, writer);
        return writer.toString();
    }

    public static String toString(Reader reader, int numberOfCharacters) throws IOException {
        StringWriter writer = new StringWriter();
        IoUtilities.pipe(reader, writer, 4096, (long)numberOfCharacters);
        return writer.toString();
    }

    public static IOException close(AutoCloseable closeable) {
        try {
            Optional.of(Exception.class, (Object)closeable).consume(AutoCloseable::close).get();
            return null;
        }
        catch (Exception e) {
            return IoUtilities.asIOException(e);
        }
    }

    public static IOException close(Closeable closeable, Closeable other, Closeable ... others) {
        LinkedList throwables = new LinkedList();
        Optional.of((Object)IoUtilities.close(closeable)).consume(throwables::add);
        Optional.of((Object)IoUtilities.close(other)).consume(throwables::add);
        for (Closeable value : others) {
            Optional.of((Object)IoUtilities.close(value)).consume(throwables::add);
        }
        return (IOException)Throwables.concat(IoUtilities::asIOException, throwables);
    }

    public static void closeAndThrow(Closeable closeable, Closeable other, Closeable ... others) throws IOException {
        IOException exception = IoUtilities.close(closeable, other, others);
        IoUtilities.throwIfNotNull(exception);
    }

    public static IOException close(IOException exception, AutoCloseable closeable) {
        return (IOException)Throwables.concat(IoUtilities::asIOException, (Throwable[])new Throwable[]{exception, IoUtilities.close(closeable)});
    }

    public static void throwIfNotNull(Throwable throwable) throws IOException {
        Throwables.throwIfNotNull(IoUtilities::asIOException, (Throwable)throwable);
    }

    public static void throwIfNotEmpty(List<Throwable> throwables) throws IOException {
        Throwables.throwIfNotEmpty(t -> IoUtilities.asIOException(t), throwables);
    }

    public static IOException asIOException(Throwable throwable) {
        return (IOException)Optional.of((Object)throwable).convert(e -> {
            IOException ioe;
            return e instanceof IOException ? (ioe = (IOException)e) : new IOException(e.getMessage(), (Throwable)e);
        }).get();
    }

    public static IOException execute(IOException exception, IBlock<IOException> block) {
        if (block == null) {
            return exception;
        }
        try {
            block.execute();
            return exception;
        }
        catch (IOException ioException) {
            return (IOException)Throwables.concat(t -> IoUtilities.asIOException(t), (Throwable[])new Throwable[]{exception, ioException});
        }
    }

    public static String toString(InputStream inputStream, String contentEncoding, long numberOfBytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtilities.pipe(inputStream, out, 4096, numberOfBytes);
        return out.toString(contentEncoding);
    }

    public static String toString(InputStream inputStream, String contentEncoding) throws IOException {
        return IoUtilities.toString(inputStream, contentEncoding, -1L);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtilities.pipe(inputStream, out, 4096, -1L);
        return out.toByteArray();
    }

    public static int maximumLimitOfBytes(long contentLength) {
        if (contentLength > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return IoUtilities.maximumLimitOfBytes((int)contentLength);
    }

    public static int maximumLimitOfBytes(int contentLength) {
        if (contentLength < 0) {
            return Integer.MAX_VALUE;
        }
        return contentLength + 1;
    }

    public static void pipe(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IoUtilities.pipe(inputStream, outputStream);
        }
    }

    public static boolean contentEquals(File file, File other) throws FileNotFoundException, IOException {
        if (Objects.equals(file, other)) {
            return true;
        }
        if (file == null || other == null) {
            return false;
        }
        if (file.isDirectory() || other.isDirectory()) {
            return false;
        }
        if (file.exists() && other.exists()) {
            if (file.length() != other.length()) {
                return false;
            }
            try (FileInputStream inputStream = new FileInputStream(file);
                 FileInputStream otherInputStream = new FileInputStream(other);){
                if (((InputStream)inputStream).read() != ((InputStream)otherInputStream).read()) {
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        return false;
    }
}

