/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import net.anwiba.commons.lang.functional.IApplicable;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class PathIterableFactory {
    private static ILogger logger = Logging.getLogger(PathIterableFactory.class);

    public <T> Iterable<T> create(final IApplicable<Path> applicable, final IConverter<Path, T, RuntimeException> converter, Path path) {
        final DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                if (Files.isSymbolicLink(entry)) {
                    return false;
                }
                return Files.isDirectory(entry, new LinkOption[0]) || applicable.isApplicable((Object)entry);
            }
        };
        final Stack<Path> paths = new Stack<Path>();
        paths.add(path);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    T next = null;

                    @Override
                    public T next() {
                        try {
                            if (this.next == null && !this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object t = this.next;
                            return t;
                        }
                        finally {
                            this.next = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (!paths.isEmpty()) {
                            Path nextPath = (Path)paths.pop();
                            try {
                                if (Files.isDirectory(nextPath, new LinkOption[0])) {
                                    Files.newDirectoryStream(nextPath, filter).forEach(p -> paths.add(p));
                                    continue;
                                }
                            }
                            catch (IOException exception) {
                                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                            }
                            if (!applicable.isApplicable((Object)nextPath)) continue;
                            this.next = converter.convert((Object)nextPath);
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }
}

