/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.anwiba.commons.lang.optional.Optional;

public class PathUtilities {
    public static String getExtension(Path path) {
        return PathUtilities.getExtension((String)Optional.of((Object)path.getFileName()).convert(n -> n.toString()).getOr(() -> ""));
    }

    public static String getExtension(Path path, String ... extensions) {
        return Arrays.stream(extensions).filter(extension -> PathUtilities.hasExtension(path, extension)).findFirst().orElseGet(() -> null);
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        return i > 0 && i < name.length() - 1 ? name.substring(i + 1).toLowerCase() : null;
    }

    public static Path addExtension(Path path, String extension) {
        String name = (String)Optional.of((Object)path.getFileName()).convert(n -> n.toString()).getOr(() -> "");
        return path.getParent() == null ? path.getFileSystem().getPath(name + "." + extension, new String[0]) : path.getFileSystem().getPath(path.getParent().toString(), name + "." + extension);
    }

    public static Path getFileWithoutExtension(Path path) {
        if (PathUtilities.getExtension(path) == null) {
            return path;
        }
        String name = (String)Optional.of((Object)path.getFileName()).convert(n -> n.toString()).getOr(() -> "");
        int index = name.lastIndexOf(46);
        return path.getParent() == null ? path.getFileSystem().getPath(name.substring(0, index), new String[0]) : path.getFileSystem().getPath(path.getParent().toString(), name.substring(0, index));
    }

    public static boolean hasExtension(Path path, String ... extentions) {
        String value = PathUtilities.getExtension(path);
        if (value == null) {
            return false;
        }
        for (String extention : extentions) {
            if (!value.equalsIgnoreCase(extention)) continue;
            return true;
        }
        return false;
    }

    public static Path getFileWithoutExtention(Path path, String ... extentions) {
        if (PathUtilities.hasExtension(path, extentions)) {
            return PathUtilities.getFileWithoutExtension(path);
        }
        return path;
    }

    public static FileSystem getFileSystem(URI uri) throws IOException {
        try {
            if (Objects.equals(uri.getScheme(), FileSystems.getDefault().provider().getScheme())) {
                return FileSystems.getDefault();
            }
            return FileSystems.newFileSystem(uri, Map.of());
        }
        catch (FileSystemAlreadyExistsException e) {
            return FileSystems.getFileSystem(uri);
        }
    }

    public static Path create(URI uri) throws IOException {
        return PathUtilities.getFileSystem(uri).provider().getPath(uri);
    }

    public static Path create(List<String> path) {
        return PathUtilities.create((String[])path.toArray(String[]::new));
    }

    public static Path create(String[] path) {
        if (path == null) {
            return null;
        }
        if (path.length == 0) {
            return Paths.get("", new String[0]);
        }
        if (path.length == 1) {
            return Paths.get(path[0], new String[0]);
        }
        String[] subpath = new String[path.length - 1];
        System.arraycopy(path, 1, subpath, 0, path.length - 1);
        return Paths.get(path[0], subpath);
    }

    public static List<Path> collectFolders(Path folder, final Predicate<Path> predicate) throws IOException {
        final LinkedList<Path> folders = new LinkedList<Path>();
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (predicate.test(dir)) {
                    folders.add(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return folders;
    }

    public static void deleteIfExits(Path folder) throws IOException {
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.visitFile(file, attrs);
                Files.deleteIfExists(file);
                return result;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileVisitResult result = super.postVisitDirectory(dir, exc);
                Files.deleteIfExists(dir);
                return result;
            }
        });
    }
}

