/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.anwiba.commons.reference.utilities.IPrimaryType;

public final class PrimaryType
implements IPrimaryType {
    private static final Set<IPrimaryType> types = new LinkedHashSet<IPrimaryType>();
    public static final IPrimaryType APPLICATION = PrimaryType.add("application");
    public static final IPrimaryType AUDIO = PrimaryType.add("audio");
    public static final IPrimaryType EXAMPLE = PrimaryType.add("example");
    public static final IPrimaryType IMAGE = PrimaryType.add("image");
    public static final IPrimaryType MESSAGE = PrimaryType.add("message");
    public static final IPrimaryType MODEL = PrimaryType.add("model");
    public static final IPrimaryType MULTIPART = PrimaryType.add("multipart");
    public static final IPrimaryType TEXT = PrimaryType.add("text");
    public static final IPrimaryType VIDEO = PrimaryType.add("video");
    public static final IPrimaryType X_GIS = PrimaryType.add("x-gis");
    private final String value;

    private static final IPrimaryType add(String name) {
        PrimaryType type = new PrimaryType(name);
        types.add(type);
        return type;
    }

    PrimaryType(String value) {
        this.value = value.toLowerCase();
    }

    public static IPrimaryType getByName(String name) {
        return types.stream().filter(type -> type.toString().equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Unknown primary content type {0}", name)));
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPrimaryType)) {
            return false;
        }
        IPrimaryType other = (IPrimaryType)obj;
        return Objects.equals(this.toString(), other.toString());
    }
}

