/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.anwiba.commons.reference.utilities.ISecondaryType;

public final class SecondaryType
implements ISecondaryType {
    private static final Set<ISecondaryType> types = new LinkedHashSet<ISecondaryType>();
    public static final ISecondaryType CSV = SecondaryType.add("cvs");
    public static final ISecondaryType CSS = SecondaryType.add("css");
    public static final ISecondaryType HTML = SecondaryType.add("html");
    public static final ISecondaryType XHTML_XML = SecondaryType.add("xhtml+xml");
    public static final ISecondaryType PLAIN = SecondaryType.add("plain");
    public static final ISecondaryType QML = SecondaryType.add("qml+csv");
    public static final ISecondaryType OCTET_STREAM = SecondaryType.add("octet-stream");
    public static final ISecondaryType FORM_URLENCODED = SecondaryType.add("x-www-form-urlencoded");
    public static final ISecondaryType DOCX = SecondaryType.add("vnd.openxmlformats-officedocument.wordprocessingml.document");
    public static final ISecondaryType GPX = SecondaryType.add("gpx+xml");
    public static final ISecondaryType JSON = SecondaryType.add("json");
    public static final ISecondaryType GEOJSON = SecondaryType.add("vnd.geo+json");
    public static final ISecondaryType JAVASCRIPT = SecondaryType.add("javascript");
    public static final ISecondaryType KML = SecondaryType.add("vnd.google-earth.kml+xml");
    public static final ISecondaryType MS_EXCEL = SecondaryType.add("msexcel");
    public static final ISecondaryType MS_EXCEL_2007 = SecondaryType.add("vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    public static final ISecondaryType MS_POWERPOINT = SecondaryType.add("mspowerpoint");
    public static final ISecondaryType MS_WORD = SecondaryType.add("msword");
    public static final ISecondaryType PDF = SecondaryType.add("pdf");
    public static final ISecondaryType RTF = SecondaryType.add("rtf");
    public static final ISecondaryType GML_XML = SecondaryType.add("gml+xml");
    public static final ISecondaryType OGC_SE_XML = SecondaryType.add("vnd.ogc.se_xml");
    public static final ISecondaryType OGC_SLD_XML = SecondaryType.add("vnd.ogc.sld+xml");
    public static final ISecondaryType OGC_WFS_XML = SecondaryType.add("vnd.ogc.wfs_xml");
    public static final ISecondaryType OGC_WMS_XML = SecondaryType.add("vnd.ogc.wms_xml");
    public static final ISecondaryType OGC_WMTS_XML = SecondaryType.add("vnd.ogc.wmts_xml");
    public static final ISecondaryType XML = SecondaryType.add("xml");
    public static final ISecondaryType ZIP = SecondaryType.add("zip");
    public static final ISecondaryType BMP = SecondaryType.add("bmp");
    public static final ISecondaryType GIF = SecondaryType.add("gif");
    public static final ISecondaryType JPEG = SecondaryType.add("jpeg");
    public static final ISecondaryType PNG = SecondaryType.add("png");
    public static final ISecondaryType PNG32 = SecondaryType.add("png32");
    public static final ISecondaryType SVG = SecondaryType.add("svg+xml");
    public static final ISecondaryType TIFF = SecondaryType.add("tiff");
    public static final ISecondaryType MPEG = SecondaryType.add("mpeg");
    public static final ISecondaryType MP4 = SecondaryType.add("mp4");
    public static final ISecondaryType X_WAV = SecondaryType.add("x-wav");
    public static final ISecondaryType WAV = SecondaryType.add("wav");
    public static final ISecondaryType ACC = SecondaryType.add("acc");
    public static final ISecondaryType FLAC = SecondaryType.add("flac");
    public static final ISecondaryType FORM_DATA = SecondaryType.add("form-data");
    public static final ISecondaryType X_SHAPEFILE = SecondaryType.add("x-shapefile");
    private final String value;

    private static final ISecondaryType add(String name) {
        SecondaryType type = new SecondaryType(name);
        types.add(type);
        return type;
    }

    SecondaryType(String value) {
        this.value = value.toLowerCase();
    }

    public static final ISecondaryType getByName(String name) {
        return types.stream().filter(type -> type.toString().equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("Unknown secondary content type {0}", name)));
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ISecondaryType)) {
            return false;
        }
        ISecondaryType other = (ISecondaryType)obj;
        return Objects.equals(this.toString(), other.toString());
    }
}

