/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reference.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.StringUtilities;
import net.anwiba.commons.reference.utilities.UriToUrlConverter;

public class UriUtilities {
    private static ILogger logger = Logging.getLogger((String)UriUtilities.class.getName());
    public static final String ERROR_MESSAGE = "Found illegal pattern in resource location string: {0}";
    public static final UriToUrlConverter converter = new UriToUrlConverter();

    public static URI changeUriExtension(URI base, String descriptionFile, String dataFile) {
        try {
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), UriUtilities.createDataFilePath(base.getPath(), descriptionFile, dataFile), base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached");
        }
    }

    private static String createDataFilePath(String path, String descriptionFile, String dataFile) {
        return StringUtilities.removeEqualEnd(path, descriptionFile) + dataFile;
    }

    public static String getNamenFromUriWithoutExtension(URI uri) {
        if (uri == null) {
            return null;
        }
        String name = UriUtilities.getName(uri);
        String subString = StringUtilities.getStringBeforLastChar(name, '.');
        return subString == null ? null : subString.toLowerCase();
    }

    public static String getName(URI uri) {
        if (uri == null) {
            return null;
        }
        return StringUtilities.getStringAfterLastChar(uri.getPath(), '/');
    }

    public static String getQuery(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isOpaque()) {
            return uri.getQuery();
        }
        String string = uri.toString();
        StringBuilder builder = null;
        block3: for (char c : string.toCharArray()) {
            switch (c) {
                case '?': {
                    builder = new StringBuilder();
                    continue block3;
                }
                default: {
                    if (builder == null) continue block3;
                    builder.append(c);
                }
            }
        }
        if (builder == null) {
            return null;
        }
        return builder.toString();
    }

    public static String getPath(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isOpaque()) {
            return uri.getPath();
        }
        if (uri.isAbsolute() && uri.getSchemeSpecificPart() != null) {
            UriUtilities.getPath(URI.create(uri.getSchemeSpecificPart()));
        }
        String string = uri.toString();
        StringBuilder builder = null;
        block4: for (char c : string.toCharArray()) {
            switch (c) {
                case ':': {
                    builder = new StringBuilder();
                    continue block4;
                }
                case '?': {
                    if (builder == null) {
                        return null;
                    }
                    return builder.toString();
                }
                default: {
                    if (builder == null) continue block4;
                    builder.append(c);
                }
            }
        }
        if (builder == null) {
            return null;
        }
        return builder.toString();
    }

    public static String getExtension(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isOpaque()) {
            String subString = StringUtilities.getStringAfterLastChar(uri.getPath(), '.');
            return subString.toLowerCase();
        }
        String string = uri.toString();
        StringBuilder builder = null;
        block4: for (char c : string.toCharArray()) {
            switch (c) {
                case '.': {
                    builder = new StringBuilder();
                    continue block4;
                }
                case '?': {
                    if (builder == null) {
                        return null;
                    }
                    return builder.toString().toLowerCase();
                }
                default: {
                    if (builder == null) continue block4;
                    builder.append(c);
                }
            }
        }
        if (builder == null) {
            return null;
        }
        return builder.toString().toLowerCase();
    }

    public static URI getParentUri(URI base) {
        if (base == null) {
            return null;
        }
        try {
            String path = UriUtilities.getParentFromPath(base.getPath());
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), path, base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    private static String getParentFromPath(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.equals("/")) {
            return path;
        }
        int index = path.lastIndexOf(47);
        if (index == 0) {
            return "/";
        }
        if (path.endsWith("/")) {
            return UriUtilities.getParentFromPath(path.substring(0, index - 1));
        }
        return path.substring(0, index);
    }

    public static boolean isChild(String path) {
        return path != null && path.trim().length() != 0 && !path.trim().startsWith("/") && !path.trim().startsWith("\\") && !path.contains(":");
    }

    public static URI setPath(URI base, String path) {
        try {
            if (base == null) {
                return new URI(path);
            }
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), path, base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    public static URI concat(URI base, String text) {
        try {
            if (base == null) {
                return new URI(UriUtilities.concat("", text));
            }
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), UriUtilities.concat(base.getPath(), text), base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    private static String concat(String path, String child) {
        if (child == null || child.trim().length() == 0) {
            return path;
        }
        return path + "/" + child;
    }

    public static boolean isFileUri(URI uri) {
        return uri != null && (uri.getScheme() == null || uri.getScheme().equalsIgnoreCase("file"));
    }

    public static boolean canRead(URI uri) {
        boolean bl;
        block9: {
            if (UriUtilities.isFileUri(uri)) {
                return new File(uri).canRead();
            }
            InputStream stream = UriUtilities.openInputStream(uri);
            try {
                boolean bl2 = bl = stream != null;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static boolean canWrite(URI uri) {
        boolean bl;
        block9: {
            if (UriUtilities.isFileUri(uri)) {
                return new File(uri).canWrite();
            }
            OutputStream stream = UriUtilities.openOutputStream(uri);
            try {
                bl = true;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static boolean exist(URI uri) {
        if (UriUtilities.isFileUri(uri)) {
            return new File(uri).exists();
        }
        try {
            URLConnection connection = converter.convert(uri).openConnection();
            connection.connect();
            return true;
        }
        catch (Throwable exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), exception);
            return false;
        }
    }

    public static String getContentType(URI uri) throws IOException {
        if (UriUtilities.isFileUri(uri)) {
            return Files.probeContentType(new File(uri).toPath());
        }
        return converter.convert(uri).openConnection().getContentType();
    }

    public static InputStream openInputStream(URI uri) throws IOException {
        if (UriUtilities.isFileUri(uri)) {
            return new FileInputStream(new File(uri));
        }
        return converter.convert(uri).openStream();
    }

    public static OutputStream openOutputStream(URI uri) throws IOException {
        if (UriUtilities.isFileUri(uri)) {
            return new FileOutputStream(new File(uri));
        }
        try {
            URLConnection connection = converter.convert(uri).openConnection();
            return connection.getOutputStream();
        }
        catch (MalformedURLException exception) {
            throw new IOException(exception);
        }
    }

    public static long getContentLength(URI uri) {
        try {
            if (UriUtilities.isFileUri(uri)) {
                return new File(uri).length();
            }
            URLConnection connection = converter.convert(uri).openConnection();
            return connection.getContentLength();
        }
        catch (IOException exception) {
            logger.log(ILevel.WARNING, exception.getLocalizedMessage());
            return -1L;
        }
    }

    public static void assertMatchUrlPathPattern(String pathString) {
        Pattern pattern = Pattern.compile("^\\p{Alnum}*\\:(/|\\\\){1,2}\\p{Alnum}*");
        Matcher matcher = pattern.matcher(pathString);
        if (!matcher.find()) {
            throw new IllegalArgumentException(MessageFormat.format(ERROR_MESSAGE, pathString));
        }
    }

    public static boolean isFileUrl(String pathString) {
        if (pathString == null) {
            return false;
        }
        String string = pathString.toLowerCase();
        if (string.startsWith("file:")) {
            String filePath = pathString.substring(pathString.indexOf(58) + 1, pathString.length());
            if (filePath.startsWith("./") || filePath.startsWith("../")) {
                return true;
            }
            try {
                UriUtilities.assertMatchUrlPathPattern(string);
            }
            catch (IllegalArgumentException exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHttpUrl(String pathString) {
        if (pathString == null) {
            return false;
        }
        String string = pathString.toLowerCase();
        try {
            UriUtilities.assertMatchUrlPathPattern(string);
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        return string.startsWith("http://") || string.startsWith("https://");
    }

    public static URI create(String urn) {
        Objects.requireNonNull(urn);
        if (UriUtilities.isFileUrl(urn)) {
            return !URI.create(urn).isOpaque() ? URI.create(urn) : new File(URI.create(urn).getSchemeSpecificPart()).toURI();
        }
        if (UriUtilities.isHttpUrl(urn)) {
            return URI.create(urn);
        }
        return new File(urn).toURI();
    }
}

