/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IInjektionAnalyserResult;
import net.anwiba.commons.reflection.IInjektionAnalyserValueResult;
import net.anwiba.commons.reflection.IReflectionValueInjectionAnalyser;
import net.anwiba.commons.reflection.InjektionAnalyserResult;
import net.anwiba.commons.reflection.InjektionAnalyserValueResult;
import net.anwiba.commons.reflection.annotation.Injection;
import net.anwiba.commons.reflection.annotation.Nullable;

public class ReflectionValueInjectionAnalyser
implements IReflectionValueInjectionAnalyser {
    @Override
    public <T> IInjektionAnalyserResult analyse(IInjectingFactory<T> factory) {
        Method[] methods = factory.getClass().getMethods();
        List createMethods = Stream.of(methods).filter(m -> "create".equals(m.getName())).filter(m -> m.getAnnotation(Injection.class) != null).collect(Collectors.toList());
        if (createMethods.size() != 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<IInjektionAnalyserValueResult> results = new ArrayList<IInjektionAnalyserValueResult>();
        Method method = (Method)createMethods.get(0);
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            results.add(this.analyse(parameter));
            ++n2;
        }
        try {
            Class<?> clazz = method.getReturnType();
            return InjektionAnalyserResult.create(clazz, results, factory);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> IInjektionAnalyserResult analyse(Class<T> clazz) {
        int n;
        int n2;
        AnnotatedElement[] annotatedElementArray;
        Field[] fieldArray = clazz.getDeclaredFields();
        Constructor<T> constructor = this.getConstructor(clazz);
        ArrayList<IInjektionAnalyserValueResult> results = new ArrayList<IInjektionAnalyserValueResult>();
        if (this.injectable(constructor)) {
            annotatedElementArray = constructor.getParameters();
            n2 = annotatedElementArray.length;
            n = 0;
            while (n < n2) {
                AnnotatedElement parameter = annotatedElementArray[n];
                results.add(this.analyse((Parameter)parameter));
                ++n;
            }
        }
        annotatedElementArray = fieldArray;
        n2 = fieldArray.length;
        n = 0;
        while (n < n2) {
            AnnotatedElement field = annotatedElementArray[n];
            IInjektionAnalyserValueResult result = this.analyse((Field)field);
            if (result != null) {
                results.add(result);
            }
            ++n;
        }
        return InjektionAnalyserResult.create(clazz, results);
    }

    private IInjektionAnalyserValueResult analyse(Parameter parameter) {
        boolean isNullable = this.isNullable(parameter);
        Class type = this.getType(parameter);
        boolean isIterable = this.isIterable(type);
        if (isIterable) {
            Class<? extends Type> iterableType = this.getIterableType(parameter);
            return new InjektionAnalyserValueResult(iterableType, isNullable, isIterable);
        }
        return new InjektionAnalyserValueResult(type, isNullable, isIterable);
    }

    private IInjektionAnalyserValueResult analyse(Field field) {
        if (!this.injectable(field)) {
            return null;
        }
        boolean isNullable = this.isNullable(field);
        Class type = this.getType(field);
        boolean isIterable = this.isIterable(type);
        if (isIterable) {
            Class<? extends Type> iterableType = this.getIterableType(field);
            return new InjektionAnalyserValueResult(iterableType, isNullable, isIterable);
        }
        return new InjektionAnalyserValueResult(type, isNullable, isIterable);
    }

    private boolean isNullable(Parameter parameter) {
        Nullable nullable = parameter.getAnnotation(Nullable.class);
        boolean isNullable = nullable != null && nullable.value();
        return isNullable;
    }

    private boolean isIterable(Class type) {
        return type.isAssignableFrom(Iterable.class);
    }

    private Class getType(Parameter parameter) {
        return parameter.getType();
    }

    private Class getType(Field field) {
        return field.getType();
    }

    private <T> Constructor<T> getConstructor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length != 1) {
            Constructor<?>[] constructorArray = constructors;
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                if (constructor.getParameterCount() == 0) {
                    return constructor;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() == 0 || this.injectable(constructor)) {
            return constructor;
        }
        throw new IllegalArgumentException();
    }

    private boolean injectable(AccessibleObject object) {
        Injection annotation = object.getAnnotation(Injection.class);
        return annotation != null && annotation.value();
    }

    private boolean isNullable(Field field) {
        Nullable nullable = field.getAnnotation(Nullable.class);
        boolean isNullable = nullable != null && nullable.value();
        return isNullable;
    }

    private Class<? extends Type> getIterableType(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return field.getGenericType().getClass();
    }

    private Class<? extends Type> getIterableType(Parameter parameter) {
        ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }
}

