/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.anwiba.commons.privileged.PrivilegedActionInvoker;
import net.anwiba.commons.reflection.CreationException;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IReflectionValueInjector;
import net.anwiba.commons.reflection.IReflectionValueProvider;
import net.anwiba.commons.reflection.InjectionException;
import net.anwiba.commons.reflection.PrivilegedFieldSetterAction;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;
import net.anwiba.commons.reflection.ReflectionMethodInvoker;
import net.anwiba.commons.reflection.annotation.Injection;
import net.anwiba.commons.reflection.annotation.Nullable;

public class ReflectionValueInjector
implements IReflectionValueInjector {
    private final PrivilegedActionInvoker<Void> invoker = new PrivilegedActionInvoker(System.getSecurityManager());
    private final IReflectionValueProvider values;

    public ReflectionValueInjector(IReflectionValueProvider values) {
        this.values = values;
    }

    @Override
    public <T> T create(IInjectingFactory<T> factory) throws CreationException {
        Method[] methods = factory.getClass().getMethods();
        List createMethods = Stream.of(methods).filter(m -> "create".equals(m.getName())).filter(m -> m.getAnnotation(Injection.class) != null).collect(Collectors.toList());
        if (createMethods.isEmpty()) {
            throw new CreationException("");
        }
        if (createMethods.size() > 1) {
            throw new CreationException("");
        }
        try {
            Method method = (Method)createMethods.get(0);
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> factoryClass = factory.getClass();
            ReflectionMethodInvoker methodInvoker = new ReflectionMethodInvoker(factoryClass, "create", parameterTypes);
            Object[] methodValues = this.getValues(method.getParameters());
            return (T)methodInvoker.invoke(factory, methodValues);
        }
        catch (IllegalStateException exception) {
            throw new CreationException("Couldn't invoke method create instance of class '" + factory.getClass().getName() + "'", exception);
        }
        catch (InvocationTargetException exception) {
            throw new CreationException("Couldn't invoke method create instance of class '" + factory.getClass().getName() + "'", exception.getCause());
        }
    }

    @Override
    public <T> T create(Class<T> clazz) throws CreationException {
        try {
            Constructor<T> constructor = this.getConstructor(clazz);
            ReflectionConstructorInvoker<T> constructorInvoker = new ReflectionConstructorInvoker<T>(clazz, constructor.getParameterTypes());
            Object[] constructorValues = this.getValues(constructor.getParameters());
            T object = constructorInvoker.invoke(constructorValues);
            this.inject(object);
            return object;
        }
        catch (InvocationTargetException exception) {
            throw new CreationException("Couldn't create instance for class '" + clazz.getName() + "'", exception.getCause());
        }
        catch (IllegalArgumentException | IllegalStateException | InjectionException exception) {
            throw new CreationException("Couldn't create instance for class '" + clazz.getName() + "'", exception);
        }
    }

    private Object[] getValues(Parameter[] parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            result.add(this.getValue(parameter));
            ++n2;
        }
        return result.toArray(new Object[result.size()]);
    }

    private <T> Constructor<T> getConstructor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length != 1) {
            Constructor<?>[] constructorArray = constructors;
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                if (constructor.getParameterCount() == 0) {
                    return constructor;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() == 0 || this.injectable(constructor)) {
            return constructor;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <T> void inject(T object) throws InjectionException {
        Field[] fieldArray;
        Class<?> clazz = object.getClass();
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            try {
                this.setValue(field, object);
            }
            catch (InvocationTargetException exception) {
                throw new InjectionException("Couldn't inject value to field '" + field.getName() + "' of class '" + object.getClass().getName() + "'", exception.getCause());
            }
            catch (IllegalStateException exception) {
                throw new InjectionException("Couldn't inject value to field '" + field.getName() + "' of class '" + object.getClass().getName() + "'", exception);
            }
            ++n2;
        }
    }

    private <T> void setValue(Field field, T object) throws InvocationTargetException {
        if (!this.injectable(field)) {
            return;
        }
        Object value = this.getValue(field);
        this.invoker.invoke(new PrivilegedFieldSetterAction(object, field.getName(), value));
    }

    private boolean injectable(AccessibleObject object) {
        Injection annotation = object.getAnnotation(Injection.class);
        return annotation != null && annotation.value();
    }

    private Object getValue(Field field) {
        Class<Iterable> clazz = field.getType();
        if (this.values.contains(clazz)) {
            return this.values.get(clazz);
        }
        if (clazz.isAssignableFrom(Iterable.class)) {
            Class<? extends Type> genericType = this.getIterableType(field);
            Collection<? extends Type> value = this.values.getAll(genericType);
            if (value != null) {
                return value;
            }
            return new ArrayList();
        }
        Nullable nullable = field.getAnnotation(Nullable.class);
        if (nullable != null && nullable.value()) {
            return null;
        }
        throw new IllegalStateException("missing injektion value for field '" + field.getName() + "'");
    }

    private Object getValue(Parameter parameter) {
        Class<Iterable> clazz = parameter.getType();
        if (clazz.isInstance(ReflectionValueInjector.class)) {
            return this;
        }
        if (this.values.contains(clazz)) {
            return this.values.get(clazz);
        }
        if (clazz.isAssignableFrom(Iterable.class)) {
            Class<? extends Type> genericType = this.getIterableType(parameter);
            Collection<? extends Type> value = this.values.getAll(genericType);
            if (value != null) {
                return value;
            }
            return new ArrayList();
        }
        Nullable nullable = parameter.getAnnotation(Nullable.class);
        if (nullable != null && nullable.value()) {
            return null;
        }
        throw new IllegalStateException("missing injektion value for field '" + parameter.getType().getName() + "'");
    }

    private Class<? extends Type> getIterableType(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return field.getGenericType().getClass();
    }

    private Class<? extends Type> getIterableType(Parameter parameter) {
        ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }
}

