/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.util.Map;
import net.anwiba.commons.reflection.CreationException;
import net.anwiba.commons.reflection.IBinding;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IInjektionObjectDescription;
import net.anwiba.commons.reflection.IReflectionValueInjector;
import net.anwiba.commons.reflection.IReflectionValueProvider;
import net.anwiba.commons.reflection.ReflectionValueInjector;
import net.anwiba.commons.reflection.ReflectionValueProvider;
import net.anwiba.commons.reflection.utilities.IValueHolder;

public final class InjektingObjectFactory {
    private final IReflectionValueInjector injector;

    public static final InjektingObjectFactory create(IReflectionValueProvider valueProvider, Map<IBinding, IValueHolder> services, Map<IBinding, IBinding> links) {
        return new InjektingObjectFactory(new ReflectionValueInjector(new ReflectionValueProvider(valueProvider, services, links)));
    }

    public InjektingObjectFactory(IReflectionValueInjector reflectionValueInjector) {
        this.injector = reflectionValueInjector;
    }

    public Object create(IInjektionObjectDescription result) throws CreationException {
        if (result.isFactory()) {
            return this.create(result.getFactory());
        }
        return this.create(result.getType());
    }

    private <T> T create(IInjectingFactory<T> factory) throws CreationException {
        return this.injector.create(factory);
    }

    private <T> T create(Class<? extends T> clazz) throws CreationException {
        return this.injector.create(clazz);
    }
}

