/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.anwiba.commons.reflection.IBinding;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IInjektionAnalyserResult;
import net.anwiba.commons.reflection.IInjektionAnalyserValueResult;
import net.anwiba.commons.reflection.IReflectionValueInjectionAnalyser;
import net.anwiba.commons.reflection.InjectableElementGetter;
import net.anwiba.commons.reflection.InjektionAnalyserResult;
import net.anwiba.commons.reflection.InjektionAnalyserValueResult;
import net.anwiba.commons.reflection.annotation.Injection;
import net.anwiba.commons.reflection.annotation.Named;
import net.anwiba.commons.reflection.annotation.Nullable;
import net.anwiba.commons.reflection.binding.ClassBinding;
import net.anwiba.commons.reflection.binding.NamedClassBinding;

public class ReflectionValueInjectionAnalyser
implements IReflectionValueInjectionAnalyser {
    private final InjectableElementGetter injectableElementGetter = new InjectableElementGetter();

    @Override
    public <T> IInjektionAnalyserResult analyse(IInjectingFactory<T> factory) {
        Method[] methods = factory.getClass().getMethods();
        List createMethods = Stream.of(methods).filter(m -> "create".equals(m.getName())).filter(m -> m.getAnnotation(Injection.class) != null).collect(Collectors.toList());
        if (createMethods.size() != 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<IInjektionAnalyserValueResult> results = new ArrayList<IInjektionAnalyserValueResult>();
        Method method = (Method)createMethods.get(0);
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            results.add(this.analyse(parameter));
            ++n2;
        }
        try {
            Class<?> clazz = method.getReturnType();
            return InjektionAnalyserResult.create(clazz, results, factory);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> IInjektionAnalyserResult analyse(Class<T> clazz) {
        try {
            Field[] fieldArray = clazz.getDeclaredFields();
            Constructor<T> constructor = this.injectableElementGetter.getConstructor(clazz);
            ArrayList<IInjektionAnalyserValueResult> results = new ArrayList<IInjektionAnalyserValueResult>();
            AnnotatedElement[] annotatedElementArray = constructor.getParameters();
            int n = annotatedElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = annotatedElementArray[n2];
                results.add(this.analyse(parameter));
                ++n2;
            }
            annotatedElementArray = fieldArray;
            n = fieldArray.length;
            n2 = 0;
            while (n2 < n) {
                AnnotatedElement field = annotatedElementArray[n2];
                if (this.injectableElementGetter.injectable((AccessibleObject)field)) {
                    results.add(this.analyse((Field)field));
                }
                ++n2;
            }
            return InjektionAnalyserResult.create(clazz, results);
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException(String.valueOf(clazz.getName()) + ", " + exception.getMessage(), exception);
        }
    }

    private IInjektionAnalyserValueResult analyse(Parameter parameter) {
        boolean isNullable = this.isNullable(parameter);
        Class type = this.getType(parameter);
        boolean isIterable = this.isIterable(type);
        String name = this.getName(null, parameter);
        if (isIterable) {
            Class<? extends Type> iterableType = this.getIterableType(parameter);
            return new InjektionAnalyserValueResult(this.binding(iterableType, name), isNullable, isIterable);
        }
        return new InjektionAnalyserValueResult(this.binding(type, name), isNullable, isIterable);
    }

    private IInjektionAnalyserValueResult analyse(Field field) {
        boolean isNullable = this.isNullable(field);
        Class type = this.getType(field);
        String name = this.getName(field.getName(), field);
        boolean isIterable = this.isIterable(type);
        if (isIterable) {
            Class<? extends Type> iterableType = this.getIterableType(field);
            return new InjektionAnalyserValueResult(this.binding(iterableType, name), isNullable, isIterable);
        }
        return new InjektionAnalyserValueResult(this.binding(type, name), isNullable, isIterable);
    }

    private <T> IBinding<T> binding(Class<T> clazz, String name) {
        return Optional.ofNullable(name).map(n -> new NamedClassBinding(clazz, (String)n)).orElseGet(() -> new ClassBinding(clazz));
    }

    private String getName(String name, AnnotatedElement annotatedElement) {
        return Optional.ofNullable(annotatedElement.getAnnotation(Named.class)).map(a -> a.value()).map(s -> s.trim()).map(n -> {
            if (n.isEmpty()) {
                if (name == null) {
                    throw new IllegalStateException("Missing annotation value");
                }
                return name;
            }
            return n;
        }).orElseGet(() -> null);
    }

    private boolean isNullable(Parameter parameter) {
        Nullable nullable = parameter.getAnnotation(Nullable.class);
        boolean isNullable = nullable != null && nullable.value();
        return isNullable;
    }

    private boolean isIterable(Class type) {
        return type.isAssignableFrom(Iterable.class);
    }

    private Class getType(Parameter parameter) {
        return parameter.getType();
    }

    private Class getType(Field field) {
        return field.getType();
    }

    private boolean isNullable(Field field) {
        Nullable nullable = field.getAnnotation(Nullable.class);
        boolean isNullable = nullable != null && nullable.value();
        return isNullable;
    }

    private Class<? extends Type> getIterableType(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return field.getGenericType().getClass();
    }

    private Class<? extends Type> getIterableType(Parameter parameter) {
        ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }
}

