/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.anwiba.commons.reflection.CreationException;
import net.anwiba.commons.reflection.IBinding;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IReflectionValueInjector;
import net.anwiba.commons.reflection.IReflectionValueProvider;
import net.anwiba.commons.reflection.InjectableElementGetter;
import net.anwiba.commons.reflection.InjectionException;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;
import net.anwiba.commons.reflection.ReflectionMethodInvoker;
import net.anwiba.commons.reflection.annotation.Injection;
import net.anwiba.commons.reflection.annotation.Named;
import net.anwiba.commons.reflection.annotation.Nullable;
import net.anwiba.commons.reflection.binding.ClassBinding;
import net.anwiba.commons.reflection.binding.NamedClassBinding;
import net.anwiba.commons.reflection.privileged.PrivilegedActionInvoker;
import net.anwiba.commons.reflection.privileged.PrivilegedFieldSetterAction;

public class ReflectionValueInjector
implements IReflectionValueInjector {
    private final InjectableElementGetter injectableElementGetter = new InjectableElementGetter();
    private final PrivilegedActionInvoker<Void> invoker = new PrivilegedActionInvoker(System.getSecurityManager());
    private final IReflectionValueProvider values;

    public ReflectionValueInjector(IReflectionValueProvider values) {
        this.values = values;
    }

    @Override
    public <T> T create(IInjectingFactory<T> factory) throws CreationException {
        Method[] methods = factory.getClass().getMethods();
        List createMethods = Stream.of(methods).filter(m -> "create".equals(m.getName())).filter(m -> m.getAnnotation(Injection.class) != null).collect(Collectors.toList());
        if (createMethods.isEmpty()) {
            throw new CreationException("");
        }
        if (createMethods.size() > 1) {
            throw new CreationException("");
        }
        try {
            Method method = (Method)createMethods.get(0);
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> factoryClass = factory.getClass();
            ReflectionMethodInvoker methodInvoker = new ReflectionMethodInvoker(factoryClass, "create", parameterTypes);
            Object[] methodValues = this.getValues(method.getParameters());
            return (T)methodInvoker.invoke(factory, methodValues);
        }
        catch (IllegalStateException exception) {
            throw new CreationException("Couldn't invoke method create instance of class '" + factory.getClass().getName() + "'", exception);
        }
        catch (InvocationTargetException exception) {
            throw new CreationException("Couldn't invoke method create instance of class '" + factory.getClass().getName() + "'", exception.getCause());
        }
    }

    @Override
    public <T> T create(Class<T> clazz) throws CreationException {
        try {
            Constructor<T> constructor = this.injectableElementGetter.getConstructor(clazz);
            ReflectionConstructorInvoker<T> constructorInvoker = new ReflectionConstructorInvoker<T>(clazz, constructor.getParameterTypes());
            Object[] constructorValues = this.getValues(constructor.getParameters());
            T object = constructorInvoker.invoke(constructorValues);
            this.inject(object);
            return object;
        }
        catch (InvocationTargetException exception) {
            throw new CreationException("Couldn't create instance for class '" + clazz.getName() + "'", exception.getCause());
        }
        catch (IllegalArgumentException | IllegalStateException | InjectionException exception) {
            throw new CreationException("Couldn't create instance for class '" + clazz.getName() + "'", exception);
        }
    }

    private Object[] getValues(Parameter[] parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            result.add(this.getValue(parameter));
            ++n2;
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    public <T> void inject(T object) throws InjectionException {
        Field[] fieldArray;
        Class<?> clazz = object.getClass();
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            try {
                this.setValue(field, object);
            }
            catch (InvocationTargetException exception) {
                throw new InjectionException("Couldn't inject value to field '" + field.getName() + "' of class '" + object.getClass().getName() + "'", exception.getCause());
            }
            catch (IllegalStateException exception) {
                throw new InjectionException("Couldn't inject value to field '" + field.getName() + "' of class '" + object.getClass().getName() + "'", exception);
            }
            ++n2;
        }
    }

    private <T> void setValue(Field field, T object) throws InvocationTargetException {
        if (!this.injectableElementGetter.injectable(field)) {
            return;
        }
        Object value = this.getValue(field);
        this.invoker.invoke(new PrivilegedFieldSetterAction(object, field.getName(), value));
    }

    private Object getValue(Field field) {
        IBinding binding = this.createBnding(field);
        Class<Iterable> clazz = field.getType();
        if (clazz.isAssignableFrom(Iterable.class)) {
            Collection value = this.values.getAll(binding);
            if (value != null) {
                return value;
            }
            return new ArrayList();
        }
        if (this.values.contains(binding)) {
            return this.values.get(binding);
        }
        Nullable nullable = field.getAnnotation(Nullable.class);
        if (nullable != null && nullable.value()) {
            return null;
        }
        throw new IllegalStateException("missing injektion value for field '" + field.getName() + "'");
    }

    private IBinding createBnding(Field field) {
        Class<Iterable> clazz = field.getType();
        String name = this.getName(field.getName(), field);
        if (clazz.isAssignableFrom(Iterable.class)) {
            Class<? extends Type> genericType = this.getIterableType(field);
            return this.binding(genericType, name);
        }
        return this.binding(clazz, name);
    }

    private <T> IBinding<T> binding(Class<T> clazz, String name) {
        return Optional.ofNullable(name).map(n -> new NamedClassBinding(clazz, (String)n)).orElseGet(() -> new ClassBinding(clazz));
    }

    private String getName(String name, AnnotatedElement annotatedElement) {
        return Optional.ofNullable(annotatedElement.getAnnotation(Named.class)).map(a -> a.value()).map(s -> s.trim().isEmpty() ? name : s).orElseGet(() -> null);
    }

    private Object getValue(Parameter parameter) {
        Class<Object> clazz = parameter.getType();
        if (clazz.isAssignableFrom(IReflectionValueInjector.class)) {
            return this;
        }
        IBinding binding = this.createBnding(parameter);
        if (clazz.isAssignableFrom(Iterable.class)) {
            Collection value = this.values.getAll(binding);
            if (value != null) {
                return value;
            }
            return new ArrayList();
        }
        if (this.values.contains(binding)) {
            return this.values.get(binding);
        }
        Nullable nullable = parameter.getAnnotation(Nullable.class);
        if (nullable != null && nullable.value()) {
            return null;
        }
        throw new IllegalStateException("missing injektion value for field '" + parameter.getType().getName() + "'");
    }

    private IBinding createBnding(Parameter parameter) {
        Class<Iterable> clazz = parameter.getType();
        String name = this.getName(parameter.getName(), parameter);
        if (clazz.isAssignableFrom(Iterable.class)) {
            Class<? extends Type> genericType = this.getIterableType(parameter);
            return this.binding(genericType, name);
        }
        return this.binding(clazz, name);
    }

    private Class<? extends Type> getIterableType(Field field) {
        if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            Type[] actualTypeArguments = genericType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return field.getGenericType().getClass();
    }

    private Class<? extends Type> getIterableType(Parameter parameter) {
        ParameterizedType parameterizedType = (ParameterizedType)parameter.getParameterizedType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }
}

