/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.anwiba.commons.reflection.IBinding;
import net.anwiba.commons.reflection.IReflectionValueProvider;
import net.anwiba.commons.reflection.binding.ClassBinding;
import net.anwiba.commons.reflection.utilities.IValueHolder;
import net.anwiba.commons.reflection.utilities.ListValueHolder;
import net.anwiba.commons.reflection.utilities.SingleValueHolder;

public final class ReflectionValueProvider
implements IReflectionValueProvider {
    private final Map<IBinding, IValueHolder> services;
    private final Map<IBinding, IBinding> links;
    private final IReflectionValueProvider valueProvider;

    public ReflectionValueProvider(IReflectionValueProvider valueProvider, Map<IBinding, IValueHolder> services, Map<IBinding, IBinding> links) {
        this.valueProvider = valueProvider;
        this.services = services;
        this.links = links;
    }

    @Override
    public <T> Collection<T> getAll(IBinding<T> binding) {
        if (this.links.containsKey(binding)) {
            return this.getAll(this.links.get(binding));
        }
        IValueHolder holder = this.services.get(binding);
        if (holder == null) {
            return this.valueProvider.getAll(binding);
        }
        if (holder instanceof SingleValueHolder) {
            Object value = ((SingleValueHolder)holder).getValue();
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(value));
            values.addAll(this.valueProvider.getAll(binding));
            return values;
        }
        if (holder instanceof ListValueHolder) {
            List values = ((ListValueHolder)holder).getValue().stream().map(v -> v).collect(Collectors.toList());
            values.addAll(this.valueProvider.getAll(binding));
            return values;
        }
        throw new IllegalStateException();
    }

    @Override
    public <T> T get(IBinding<T> binding) {
        if (this.links.containsKey(binding)) {
            T object = this.get(this.links.get(binding));
            return object;
        }
        if (!this.services.containsKey(binding)) {
            return this.valueProvider.get(binding);
        }
        IValueHolder holder = this.services.get(binding);
        if (holder == null) {
            return null;
        }
        if (holder instanceof SingleValueHolder) {
            Object value = ((SingleValueHolder)holder).getValue();
            return (T)value;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean contains(IBinding<?> binding) {
        if (this.links.containsKey(binding)) {
            IBinding link = this.links.get(binding);
            return this.services.containsKey(link) || this.valueProvider.contains(link);
        }
        return this.services.containsKey(binding) || this.valueProvider.contains(binding);
    }

    public boolean contains(Class clazz) {
        return this.contains(this.binding(clazz));
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return this.get(this.binding(clazz));
    }

    @Override
    public <T> Collection<T> getAll(Class<T> clazz) {
        return this.getAll(this.binding(clazz));
    }

    private <T> IBinding<T> binding(Class<T> clazz) {
        return new ClassBinding<T>(clazz);
    }
}

