/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.anwiba.commons.reflection.privileged.PrivilegedActionInvoker;
import net.anwiba.commons.reflection.privileged.PrivilegedMethodInvokeAction;

public class ReflectionMethodInvoker<C, R> {
    private final PrivilegedActionInvoker<R> invoker = new PrivilegedActionInvoker(System.getSecurityManager());
    private final Class<? extends C> clazz;
    private final Function<Method[], String> methodNameExtractor;
    private final Function<Method[], Class<?>[]> argumentTypesExtractor;
    private final BiFunction<Object[], Class<?>[], Object[]> valuesConverter;

    public static <C, R> ReflectionMethodInvoker<C, R> createSetter(Class<? extends C> clazz, String annotationName, String parameterName, String parameterValue) {
        Function<Method[], String> methodNameExtractor = methods -> ReflectionMethodInvoker.extractSetterName(methods, annotationName, parameterName, parameterValue);
        Function<Method[], Class<?>[]> argumentTypesExtractor = methods -> ReflectionMethodInvoker.extractSetterArgumentTypes(methods, annotationName, parameterName, parameterValue);
        BiFunction<Object[], Class<?>[], Object[]> valuesConverter = (values, classes) -> ReflectionMethodInvoker.convertValues(values, classes);
        return new ReflectionMethodInvoker<C, R>(clazz, methodNameExtractor, argumentTypesExtractor, valuesConverter);
    }

    private static Object[] convertValues(Object[] values, Class<?>[] classes) {
        Object[] result = new Object[values.length];
        int i = 0;
        while (i < classes.length) {
            result[i] = ReflectionMethodInvoker.convertValue(values[i], classes[i]);
            ++i;
        }
        return result;
    }

    private static Object convertValue(Object object, Class<?> clazz) {
        if (object == null || !clazz.isArray() || object.getClass().isArray() && clazz.isArray()) {
            return object;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.isInstance(Collection.class)) {
            Class<?> componentType = clazz.getComponentType();
            return ReflectionMethodInvoker.createArray(componentType, (Collection)object);
        }
        return null;
    }

    private static <C> C[] createArray(Class<C> type, Collection collection) {
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        int counter = 0;
        for (Object object : collection) {
            array[counter++] = type.cast(object);
        }
        return array;
    }

    private static Class<?>[] extractSetterArgumentTypes(Method[] methods, String annotationName, String parameterName, String parameterValue) {
        return Optional.ofNullable(ReflectionMethodInvoker.extract(methods, annotationName, parameterName, parameterValue, Void.TYPE)).map(method -> method.getParameterTypes()).orElseGet(() -> new Class[0]);
    }

    private static String extractSetterName(Method[] methods, String annotationName, String parameterName, String parameterValue) {
        return Optional.ofNullable(ReflectionMethodInvoker.extract(methods, annotationName, parameterName, parameterValue, Void.TYPE)).map(method -> method.getName()).orElseGet(() -> null);
    }

    private static Method extract(Method[] methods, String annotationName, String parameterName, String parameterValue, Class returnType) {
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getReturnType().equals(returnType) && method.getParameterCount() == 1 && ReflectionMethodInvoker.hasAnnotation(method.getAnnotations(), annotationName, parameterName, parameterValue)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasAnnotation(Annotation[] annotations, String annotationName, String parameterName, String parameterValue) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String simpleName = annotationType.getSimpleName();
            if (simpleName.equals(annotationName)) {
                try {
                    ReflectionMethodInvoker invoker = new ReflectionMethodInvoker(annotationType, parameterName, new Class[0]);
                    if (Objects.equals(invoker.invoke(annotation, new Object[0]), parameterValue)) {
                        return true;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    public ReflectionMethodInvoker(Class<? extends C> clazz, Function<Method[], String> methodNameExtractor, Function<Method[], Class<?>[]> argumentTypesExtractor, BiFunction<Object[], Class<?>[], Object[]> valuesConverter) {
        this.clazz = clazz;
        this.methodNameExtractor = methodNameExtractor;
        this.argumentTypesExtractor = argumentTypesExtractor;
        this.valuesConverter = valuesConverter;
    }

    public ReflectionMethodInvoker(Class<? extends C> clazz, String methodName, Class<?> ... argumentTypes) {
        this.clazz = clazz;
        this.methodNameExtractor = methods -> methodName;
        this.argumentTypesExtractor = methods -> argumentTypes;
        this.valuesConverter = (values, classes) -> values;
    }

    public R invoke(Object object, Object ... arguments) throws InvocationTargetException {
        return this.invoker.invoke(new PrivilegedMethodInvokeAction(this.clazz, this.methodNameExtractor, this.argumentTypesExtractor, this.valuesConverter, object, arguments));
    }
}

