/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.anwiba.commons.privileged.PrivilegedActionInvoker;
import net.anwiba.commons.reflection.OptionalPrivilegedMethodInvokeAction;

public class OptionalReflectionMethodInvoker<C, R> {
    private final PrivilegedActionInvoker<R> invoker = new PrivilegedActionInvoker(System.getSecurityManager());
    private final Class<? extends C> clazz;
    private final Function<Method[], String> methodNameExtractor;
    private final Function<Method[], Class<?>[]> argumentTypesExtractor;
    private final BiFunction<Object[], Class<?>[], Object[]> valuesConverter;

    public static <C, R> OptionalReflectionMethodInvoker<C, R> createSetter(Class<? extends C> clazz, String annotationName, String parameterName, String parameterValue) {
        Function<Method[], String> methodNameExtractor = methods -> OptionalReflectionMethodInvoker.extractSetterName(methods, annotationName, parameterName, parameterValue);
        Function<Method[], Class<?>[]> argumentTypesExtractor = methods -> OptionalReflectionMethodInvoker.extractSetterArgumentTypes(methods, annotationName, parameterName, parameterValue);
        BiFunction<Object[], Class<?>[], Object[]> valuesConverter = (values, classes) -> OptionalReflectionMethodInvoker.convertValues(values, classes);
        return new OptionalReflectionMethodInvoker<C, R>(clazz, methodNameExtractor, argumentTypesExtractor, valuesConverter);
    }

    private static Object[] convertValues(Object[] values, Class<?>[] classes) {
        Object[] result = new Object[values.length];
        int i = 0;
        while (i < classes.length) {
            result[i] = OptionalReflectionMethodInvoker.convertValue(values[i], classes[i]);
            ++i;
        }
        return result;
    }

    private static Object convertValue(Object object, Class<?> clazz) {
        if (object == null || !clazz.isArray() || object.getClass().isArray() && clazz.isArray()) {
            return object;
        }
        object.getClass();
        if (Collection.class.isInstance(object)) {
            Class<Serializable> componentType = clazz.getComponentType();
            if (componentType.isAssignableFrom(Double.TYPE)) {
                return OptionalReflectionMethodInvoker.createDoubleArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Float.TYPE)) {
                return OptionalReflectionMethodInvoker.createFloatArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Long.TYPE)) {
                return OptionalReflectionMethodInvoker.createLongArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Integer.TYPE)) {
                return OptionalReflectionMethodInvoker.createIntArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Short.TYPE)) {
                return OptionalReflectionMethodInvoker.createShortArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Boolean.TYPE)) {
                return OptionalReflectionMethodInvoker.createBooleanArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Byte.TYPE)) {
                return OptionalReflectionMethodInvoker.createByteArray((Collection)object);
            }
            if (componentType.isAssignableFrom(Character.TYPE)) {
                return OptionalReflectionMethodInvoker.createCharArray((Collection)object);
            }
            return OptionalReflectionMethodInvoker.createArray(componentType, (Collection)object);
        }
        return null;
    }

    private static double[] createDoubleArray(Collection collection) {
        double[] array = new double[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).doubleValue();
            ++i;
        }
        return array;
    }

    private static float[] createFloatArray(Collection collection) {
        float[] array = new float[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).floatValue();
            ++i;
        }
        return array;
    }

    private static long[] createLongArray(Collection collection) {
        long[] array = new long[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).longValue();
            ++i;
        }
        return array;
    }

    private static int[] createIntArray(Collection collection) {
        int[] array = new int[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).intValue();
            ++i;
        }
        return array;
    }

    private static short[] createShortArray(Collection collection) {
        short[] array = new short[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).shortValue();
            ++i;
        }
        return array;
    }

    private static boolean[] createBooleanArray(Collection collection) {
        boolean[] array = new boolean[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = (Boolean)objects[i];
            ++i;
        }
        return array;
    }

    private static byte[] createByteArray(Collection collection) {
        byte[] array = new byte[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = (Byte)objects[i];
            ++i;
        }
        return array;
    }

    private static char[] createCharArray(Collection collection) {
        char[] array = new char[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Character)objects[i]).charValue();
            ++i;
        }
        return array;
    }

    private static <C> C[] createArray(Class<C> type, Collection collection) {
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        int counter = 0;
        for (Object object : collection) {
            array[counter++] = type.cast(object);
        }
        return array;
    }

    private static Class<?>[] extractSetterArgumentTypes(Method[] methods, String annotationName, String parameterName, String parameterValue) {
        return Optional.ofNullable(OptionalReflectionMethodInvoker.extract(methods, annotationName, parameterName, parameterValue, Void.TYPE)).map(method -> method.getParameterTypes()).orElseGet(() -> new Class[0]);
    }

    private static String extractSetterName(Method[] methods, String annotationName, String parameterName, String parameterValue) {
        return Optional.ofNullable(OptionalReflectionMethodInvoker.extract(methods, annotationName, parameterName, parameterValue, Void.TYPE)).map(method -> method.getName()).orElseGet(() -> null);
    }

    private static Method extract(Method[] methods, String annotationName, String parameterName, String parameterValue, Class returnType) {
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getReturnType().equals(returnType) && method.getParameterCount() == 1 && OptionalReflectionMethodInvoker.hasAnnotation(method.getAnnotations(), annotationName, parameterName, parameterValue)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasAnnotation(Annotation[] annotations, String annotationName, String parameterName, String parameterValue) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String simpleName = annotationType.getSimpleName();
            if (simpleName.equals(annotationName)) {
                try {
                    OptionalReflectionMethodInvoker invoker = new OptionalReflectionMethodInvoker(annotationType, parameterName, new Class[0]);
                    if (Objects.equals(invoker.invoke(annotation, new Object[0]), parameterValue)) {
                        return true;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    public OptionalReflectionMethodInvoker(Class<? extends C> clazz, Function<Method[], String> methodNameExtractor, Function<Method[], Class<?>[]> argumentTypesExtractor, BiFunction<Object[], Class<?>[], Object[]> valuesConverter) {
        this.clazz = clazz;
        this.methodNameExtractor = methodNameExtractor;
        this.argumentTypesExtractor = argumentTypesExtractor;
        this.valuesConverter = valuesConverter;
    }

    public OptionalReflectionMethodInvoker(Class<? extends C> clazz, String methodName, Class<?> ... argumentTypes) {
        this.clazz = clazz;
        this.methodNameExtractor = methods -> methodName;
        this.argumentTypesExtractor = methods -> argumentTypes;
        this.valuesConverter = (values, classes) -> values;
    }

    public R invoke(Object object, Object ... arguments) throws InvocationTargetException {
        return this.invoker.invoke(new OptionalPrivilegedMethodInvokeAction(this.clazz, this.methodNameExtractor, this.argumentTypesExtractor, this.valuesConverter, object, arguments));
    }
}

