/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.anwiba.commons.reflection.IReflectionValueProvider;
import net.anwiba.commons.reflection.utilities.IValueHolder;
import net.anwiba.commons.reflection.utilities.ListValueHolder;
import net.anwiba.commons.reflection.utilities.SingleValueHolder;

public final class ReflectionValueProvider
implements IReflectionValueProvider {
    private final Map<Class, IValueHolder> services;
    private final Map<Class, Class> links;
    private final IReflectionValueProvider valueProvider;

    public ReflectionValueProvider(IReflectionValueProvider valueProvider, Map<Class, IValueHolder> services, Map<Class, Class> links) {
        this.valueProvider = valueProvider;
        this.services = services;
        this.links = links;
    }

    @Override
    public <T> Collection<T> getAll(Class<T> componentType) {
        if (this.links.containsKey(componentType)) {
            return this.getAll(this.links.get(componentType));
        }
        IValueHolder holder = this.services.get(componentType);
        if (holder == null) {
            return this.valueProvider.getAll(componentType);
        }
        if (holder instanceof SingleValueHolder) {
            Object value = ((SingleValueHolder)holder).getValue();
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(value));
            values.addAll(this.valueProvider.getAll(componentType));
            return values;
        }
        if (holder instanceof ListValueHolder) {
            List values = ((ListValueHolder)holder).getValue().stream().map(v -> v).collect(Collectors.toList());
            values.addAll(this.valueProvider.getAll(componentType));
            return values;
        }
        throw new IllegalStateException();
    }

    @Override
    public <T> T get(Class<T> componentType) {
        if (this.links.containsKey(componentType)) {
            T object = this.get(this.links.get(componentType));
            return object;
        }
        if (!this.services.containsKey(componentType)) {
            return this.valueProvider.get(componentType);
        }
        IValueHolder holder = this.services.get(componentType);
        if (holder == null) {
            return null;
        }
        if (holder instanceof SingleValueHolder) {
            Object value = ((SingleValueHolder)holder).getValue();
            return (T)value;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean contains(Class<?> clazz) {
        if (this.links.containsKey(clazz)) {
            Class link = this.links.get(clazz);
            return this.services.containsKey(link) || this.valueProvider.contains(link);
        }
        return this.services.containsKey(clazz) || this.valueProvider.contains(clazz);
    }
}

