/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IInjektionAnalyserResult;
import net.anwiba.commons.reflection.IInjektionAnalyserValueResult;

public final class InjektionAnalyserResult
implements IInjektionAnalyserResult {
    private final List<IInjektionAnalyserValueResult> results;
    private final List<Class> types;
    private final Map<Class, IInjektionAnalyserValueResult> map;
    private final Class type;
    private final IInjectingFactory factory;

    public static IInjektionAnalyserResult create(Class type, List<IInjektionAnalyserValueResult> results) {
        return InjektionAnalyserResult.create(type, results, null);
    }

    public static IInjektionAnalyserResult create(Class type, List<IInjektionAnalyserValueResult> results, IInjectingFactory factory) {
        ArrayList<Class> types = new ArrayList<Class>();
        HashMap<Class, IInjektionAnalyserValueResult> map = new HashMap<Class, IInjektionAnalyserValueResult>();
        for (IInjektionAnalyserValueResult result : results) {
            types.add(result.getType());
            map.put(result.getType(), result);
        }
        return new InjektionAnalyserResult(type, results, types, map, factory);
    }

    private InjektionAnalyserResult(Class type, List<IInjektionAnalyserValueResult> results, List<Class> types, Map<Class, IInjektionAnalyserValueResult> map, IInjectingFactory factory) {
        this.type = type;
        this.results = results;
        this.types = types;
        this.map = map;
        this.factory = factory;
    }

    @Override
    public Iterable<Class> getTypes() {
        return this.types;
    }

    @Override
    public boolean isNullable(Class clazz) {
        IInjektionAnalyserValueResult result = this.map.get(clazz);
        if (result == null) {
            throw new IllegalStateException();
        }
        return result.isNullable();
    }

    @Override
    public boolean isIterable(Class clazz) {
        IInjektionAnalyserValueResult result = this.map.get(clazz);
        if (result == null) {
            throw new IllegalStateException();
        }
        return result.isIterable();
    }

    @Override
    public boolean hasNullable() {
        return this.results.stream().anyMatch(i -> i.isNullable());
    }

    @Override
    public boolean hasIterable() {
        return this.results.stream().anyMatch(i -> i.isIterable());
    }

    @Override
    public boolean isIndependent() {
        return this.types.isEmpty();
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public IInjectingFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean isFactory() {
        return this.factory != null;
    }
}

