/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection.privileged;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PrivilegedActionInvoker<T> {
    public final SecurityManager securityManager;

    public PrivilegedActionInvoker(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public T invoke(PrivilegedAction<T> action) throws InvocationTargetException {
        try {
            if (this.securityManager == null) {
                return action.run();
            }
            return AccessController.doPrivileged(action);
        }
        catch (RuntimeException exception) {
            if (exception.getCause() instanceof InvocationTargetException) {
                throw (InvocationTargetException)exception.getCause();
            }
            if (exception.getCause() != null) {
                throw new InvocationTargetException(exception.getCause());
            }
            throw exception;
        }
    }
}

