/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.anwiba.commons.reflection.privileged.OptionalPrivilegedMethodInvokeAction;
import net.anwiba.commons.reflection.privileged.PrivilegedActionInvoker;
import net.anwiba.commons.reflection.utilities.ObjectToArrayConverter;

public class OptionalReflectionMethodInvoker<C, R> {
    private final PrivilegedActionInvoker<R> invoker = new PrivilegedActionInvoker(System.getSecurityManager());
    private final Class<? extends C> clazz;
    private final Function<Method[], String> methodNameExtractor;
    private final Function<Method[], Class<?>[]> argumentTypesExtractor;
    private final BiFunction<Object[], Class<?>[], Object[]> valuesConverter;

    public static <C, R> OptionalReflectionMethodInvoker<C, R> createSetter(Class<? extends C> clazz, String annotationName, String parameterName, String parameterValue) {
        Function<Method[], String> methodNameExtractor = methods -> OptionalReflectionMethodInvoker.extractSetterName(methods, annotationName, parameterName, parameterValue);
        Function<Method[], Class<?>[]> argumentTypesExtractor = methods -> OptionalReflectionMethodInvoker.extractSetterArgumentTypes(methods, annotationName, parameterName, parameterValue);
        BiFunction<Object[], Class<?>[], Object[]> valuesConverter = (values, classes) -> OptionalReflectionMethodInvoker.convertValues(values, classes);
        return new OptionalReflectionMethodInvoker<C, R>(clazz, methodNameExtractor, argumentTypesExtractor, valuesConverter);
    }

    private static Object[] convertValues(Object[] values, Class<?>[] classes) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = OptionalReflectionMethodInvoker.convertValue(values[i], classes[i]);
        }
        return result;
    }

    private static Object convertValue(Object object, Class<?> clazz) {
        if (object == null || !clazz.isArray() || object.getClass().isArray() && clazz.isArray()) {
            return object;
        }
        if (Collection.class.isInstance(object)) {
            return ObjectToArrayConverter.toArray((Collection)object, clazz);
        }
        return null;
    }

    private static Class<?>[] extractSetterArgumentTypes(Method[] methods, String annotationName, String parameterName, String parameterValue) {
        return Optional.ofNullable(OptionalReflectionMethodInvoker.extract(methods, annotationName, parameterName, parameterValue, Void.TYPE)).map(method -> method.getParameterTypes()).orElseGet(() -> new Class[0]);
    }

    private static String extractSetterName(Method[] methods, String annotationName, String parameterName, String parameterValue) {
        return Optional.ofNullable(OptionalReflectionMethodInvoker.extract(methods, annotationName, parameterName, parameterValue, Void.TYPE)).map(method -> method.getName()).orElseGet(() -> null);
    }

    private static Method extract(Method[] methods, String annotationName, String parameterName, String parameterValue, Class returnType) {
        for (Method method : methods) {
            if (!method.getReturnType().equals(returnType) || method.getParameterCount() != 1 || !OptionalReflectionMethodInvoker.hasAnnotation(method.getAnnotations(), annotationName, parameterName, parameterValue)) continue;
            return method;
        }
        return null;
    }

    private static boolean hasAnnotation(Annotation[] annotations, String annotationName, String parameterName, String parameterValue) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String simpleName = annotationType.getSimpleName();
            if (!simpleName.equals(annotationName)) continue;
            try {
                OptionalReflectionMethodInvoker invoker = new OptionalReflectionMethodInvoker(annotationType, parameterName, new Class[0]);
                if (!Objects.equals(invoker.invoke(annotation, new Object[0]), parameterValue)) continue;
                return true;
            }
            catch (InvocationTargetException exception) {
                return false;
            }
        }
        return false;
    }

    public OptionalReflectionMethodInvoker(Class<? extends C> clazz, Function<Method[], String> methodNameExtractor, Function<Method[], Class<?>[]> argumentTypesExtractor, BiFunction<Object[], Class<?>[], Object[]> valuesConverter) {
        this.clazz = clazz;
        this.methodNameExtractor = methodNameExtractor;
        this.argumentTypesExtractor = argumentTypesExtractor;
        this.valuesConverter = valuesConverter;
    }

    public OptionalReflectionMethodInvoker(Class<? extends C> clazz, String methodName, Class<?> ... argumentTypes) {
        this.clazz = clazz;
        this.methodNameExtractor = methods -> methodName;
        this.argumentTypesExtractor = methods -> argumentTypes;
        this.valuesConverter = (values, classes) -> values;
    }

    public R invoke(Object object, Object ... arguments) throws InvocationTargetException {
        return this.invoker.invoke(new OptionalPrivilegedMethodInvokeAction(this.clazz, this.methodNameExtractor, this.argumentTypesExtractor, this.valuesConverter, object, arguments));
    }
}

