/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection.privileged;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import net.anwiba.commons.reflection.privileged.AbstractPrivilegedAction;

public final class OptionalPrivilegedFieldSetterAction
extends AbstractPrivilegedAction<Void> {
    private final Object object;
    private final Object value;
    private final String fieldName;

    public OptionalPrivilegedFieldSetterAction(Object object, String fieldName, Object value) {
        this.object = object;
        this.fieldName = fieldName;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void invoke() {
        Field field = this.getField();
        if (field == null) {
            return null;
        }
        boolean accessible = field.canAccess(this.object);
        try {
            field.setAccessible(true);
            Object value = this.convert(field, this.value);
            field.set(this.object, value);
            Void void_ = null;
            return void_;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            Void void_ = null;
            return void_;
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private Object convert(Field field, Object value) {
        Class<double[]> declaringClass = field.getType();
        if (declaringClass.isArray()) {
            if (value == null) {
                return value;
            }
            if (value.getClass().isArray()) {
                return value;
            }
            if (Collection.class.isInstance(value)) {
                if (declaringClass.isAssignableFrom(double[].class)) {
                    return this.createDoubleArray((Collection)value);
                }
                if (declaringClass.isAssignableFrom(long[].class)) {
                    return this.createLongArray((Collection)value);
                }
                if (declaringClass.isAssignableFrom(int[].class)) {
                    return this.createIntegerArray((Collection)value);
                }
                return this.create(declaringClass, (Collection)value);
            }
        }
        return null;
    }

    private double[] createDoubleArray(Collection collection) {
        double[] array = new double[collection.size()];
        Object[] objects = collection.toArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((Number)objects[i]).doubleValue();
        }
        return array;
    }

    private long[] createLongArray(Collection collection) {
        long[] array = new long[collection.size()];
        Object[] objects = collection.toArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((Number)objects[i]).longValue();
        }
        return array;
    }

    private int[] createIntegerArray(Collection collection) {
        int[] array = new int[collection.size()];
        Object[] objects = collection.toArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = ((Number)objects[i]).intValue();
        }
        return array;
    }

    private <T> T[] create(Class declaringClass, Collection collection) {
        Object[] newInstance = (Object[])Array.newInstance(declaringClass, collection.size());
        return collection.toArray(newInstance);
    }

    private Field getField() {
        return Stream.of(this.object.getClass().getDeclaredFields()).filter(f -> Objects.equals(f.getName(), this.fieldName)).findFirst().orElseGet(() -> Stream.of(this.object.getClass().getFields()).filter(f -> Objects.equals(f.getName(), this.fieldName)).findFirst().orElseGet(() -> null));
    }
}

