/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection.privileged;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.anwiba.commons.reflection.privileged.AbstractPrivilegedAction;

public final class OptionalPrivilegedMethodInvokeAction<C, R>
extends AbstractPrivilegedAction<R> {
    private final Object object;
    private final Object[] arguments;
    private final Class<? extends C> clazz;
    private final Function<Method[], String> methodNameExtractor;
    private final Function<Method[], Class<?>[]> argumentTypesExtractor;
    private final BiFunction<Object[], Class<?>[], Object[]> valuesConverter;

    public OptionalPrivilegedMethodInvokeAction(Class<? extends C> clazz, Function<Method[], String> methodNameExtractor, Function<Method[], Class<?>[]> argumentTypesExtractor, BiFunction<Object[], Class<?>[], Object[]> valuesConverter, Object object, Object[] arguments) {
        this.clazz = clazz;
        this.methodNameExtractor = methodNameExtractor;
        this.argumentTypesExtractor = argumentTypesExtractor;
        this.valuesConverter = valuesConverter;
        this.object = object;
        this.arguments = arguments;
    }

    @Override
    protected R invoke() throws InvocationTargetException {
        Method method = this.getMethod();
        if (method == null) {
            return null;
        }
        try {
            return this.invoke(method, method.canAccess(this.object));
        }
        catch (IllegalAccessException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R invoke(Method method, boolean accessible) throws IllegalAccessException, InvocationTargetException {
        try {
            method.setAccessible(true);
            Object object = method.invoke(this.object, this.valuesConverter.apply(this.arguments, method.getParameterTypes()));
            return (R)object;
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    private Method getMethod() {
        Method[] declaredMethods = this.clazz.getDeclaredMethods();
        Method[] inhertedMethods = this.clazz.getMethods();
        Method[] methods = new Method[declaredMethods.length + inhertedMethods.length];
        System.arraycopy(declaredMethods, 0, methods, 0, declaredMethods.length);
        System.arraycopy(inhertedMethods, 0, methods, declaredMethods.length, inhertedMethods.length);
        String methodName = this.methodNameExtractor.apply(methods);
        methods = (Method[])Stream.of(methods).filter(method -> method.getName().equals(methodName)).toArray(Method[]::new);
        Class[] argumentTypes = this.argumentTypesExtractor.apply(methods);
        return Stream.of(methods).filter(method -> Arrays.equals(method.getParameterTypes(), argumentTypes)).findFirst().orElseGet(() -> null);
    }
}

