/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.time.Duration;
import net.anwiba.commons.cache.resource.CacheStorage;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.cache.resource.ILifeTime;
import net.anwiba.commons.cache.resource.LifeTime;
import net.anwiba.commons.cache.resource.ResourceAccessEvent;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;

public class CachingRule
implements ICachingRule {
    private ILifeTime preferedLifeTime;
    private ILifeTime minimumLifeTime;
    private ILifeTime maximumLifeTime;
    private CacheStorage cacheStorage;

    public static ICachingRule of() {
        return CachingRule.builder().build();
    }

    public static ICachingRule of(ILifeTime preferedLifeTime) {
        return CachingRule.of(preferedLifeTime, null, null, null);
    }

    public static ICachingRule of(ILifeTime preferedLifeTime, CacheStorage preferedCacheStorage) {
        return CachingRule.of(preferedLifeTime, preferedCacheStorage, null, null);
    }

    public static ICachingRule of(ILifeTime preferedLifeTime, CacheStorage preferedCacheStorage, ILifeTime minimumLifeTime, ILifeTime maximumLifeTime) {
        return CachingRule.builder().preferdLifeTime(preferedLifeTime).preferedCacheStorage(preferedCacheStorage).minimumLifeTime(minimumLifeTime).minimumLifeTime(maximumLifeTime).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    CachingRule(ILifeTime preferedLifeTime, CacheStorage cacheStorage, ILifeTime minimumLifeTime, ILifeTime maximumLifeTime) {
        this.preferedLifeTime = preferedLifeTime;
        this.minimumLifeTime = minimumLifeTime;
        this.maximumLifeTime = maximumLifeTime;
        this.cacheStorage = cacheStorage;
    }

    @Override
    public ILifeTime getPreferedLifeTime() {
        return this.preferedLifeTime;
    }

    @Override
    public CacheStorage getCacheStorage() {
        return this.cacheStorage;
    }

    @Override
    public IOptional<ILifeTime, RuntimeException> getMinimumLifeTime() {
        return Optional.of((Object)this.minimumLifeTime);
    }

    @Override
    public IOptional<ILifeTime, RuntimeException> getMaximumLifeTime() {
        return Optional.of((Object)this.maximumLifeTime);
    }

    @Override
    public ICachingRule adapt(CacheStorage storage) {
        return new CachingRule(this.preferedLifeTime, storage, this.minimumLifeTime, this.maximumLifeTime);
    }

    public static class Builder {
        private ILifeTime preferdLifeTime;
        private CacheStorage preferedCacheStorage;
        private ILifeTime minimumLifeTime = null;
        private ILifeTime maximumLifeTime = null;

        Builder() {
        }

        public Builder preferedCacheStorage(CacheStorage preferedCacheStorage) {
            this.preferedCacheStorage = preferedCacheStorage;
            return this;
        }

        public Builder preferdLifeTime(ILifeTime preferdLifeTime) {
            this.preferdLifeTime = preferdLifeTime;
            return this;
        }

        public Builder minimumLifeTime(ILifeTime minimumLifeTime) {
            this.minimumLifeTime = minimumLifeTime;
            return this;
        }

        public Builder maximumLifeTime(ILifeTime maximumLifeTime) {
            this.maximumLifeTime = maximumLifeTime;
            return this;
        }

        public ICachingRule build() {
            return new CachingRule(this.createPreferedLifeTime(), (CacheStorage)((Object)Optional.of((Object)((Object)this.preferedCacheStorage)).getOr(() -> (CacheStorage)((Object)((Object)Optional.of((Object)this.minimumLifeTime).convert(t -> CacheStorage.MEMORY_STATIC).getOr(() -> CacheStorage.MEMORY_WEAK))))), this.minimumLifeTime, this.maximumLifeTime);
        }

        private ILifeTime createPreferedLifeTime() {
            return LifeTime.of((Duration)Optional.of((Object)this.preferdLifeTime).convert(t -> t.getDuration()).getOr(() -> Duration.ofMinutes(5L)), (ResourceAccessEvent)((Object)Optional.of((Object)this.preferdLifeTime).convert(t -> t.getStartPointOfTimeMeasuring()).getOr(() -> ResourceAccessEvent.CREATED)));
        }
    }
}

