/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.reference.utilities.ContentType;

public interface IResourceCacheConfiguration {
    default public Duration getLatencyTime() {
        return Duration.ofSeconds(5L);
    }

    default public Duration getMaximumAgeOnStartupTime() {
        return this.getCachingRule().getPreferedLifeTime().getDuration().multipliedBy(2L);
    }

    default public boolean isCleanUpOnStartEnabled() {
        return this.getCachingFolder().isAccepted();
    }

    public ICachingRule getCachingRule();

    default public String getExtensionFor(String contentType) {
        return (String)ContentType.getByValue((String)contentType).convert(c -> (String)c.getDefaultFileExtension().getOr(() -> "bdf")).getOr(() -> "bdf");
    }

    public String getName();

    public IOptional<File, IOException> getCachingFolder();

    public boolean isApplicable(Object var1, String var2);
}

