/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.time.Duration;
import net.anwiba.commons.cache.resource.ILifeTime;
import net.anwiba.commons.cache.resource.ResourceAccessEvent;

public class LifeTime
implements ILifeTime {
    private final Duration duration;
    private final ResourceAccessEvent startPointOfTimeMeasuring;

    public static ILifeTime of() {
        return LifeTime.of(Duration.ofMinutes(5L));
    }

    public static ILifeTime of(long duration) {
        return LifeTime.of(Duration.ofMillis(duration));
    }

    public static ILifeTime of(Duration duration) {
        return LifeTime.of(duration, ResourceAccessEvent.CREATED);
    }

    public static ILifeTime of(Duration duration, ResourceAccessEvent pointOfTime) {
        return new LifeTime(duration, pointOfTime);
    }

    private LifeTime(Duration duration, ResourceAccessEvent pointOfTime) {
        this.duration = duration;
        this.startPointOfTimeMeasuring = pointOfTime;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public ResourceAccessEvent getStartPointOfTimeMeasuring() {
        return this.startPointOfTimeMeasuring;
    }
}

