/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.anwiba.commons.cache.resource.CacheStorage;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.cache.resource.ILifeTime;
import net.anwiba.commons.cache.resource.IResourceCache;
import net.anwiba.commons.cache.resource.IResourceCacheConfiguration;
import net.anwiba.commons.cache.resource.IResourceCacheListResult;
import net.anwiba.commons.cache.resource.IResourceCacheObject;
import net.anwiba.commons.cache.resource.IResourceCacheResult;
import net.anwiba.commons.cache.resource.ResourceAccessEvent;
import net.anwiba.commons.cache.resource.ResourceCacheConfigurationBuilder;
import net.anwiba.commons.cache.resource.ResourceCacheListResult;
import net.anwiba.commons.cache.resource.ResourceCacheObject;
import net.anwiba.commons.cache.resource.ResourceCacheResult;
import net.anwiba.commons.cache.resource.WeakResourceCacheObject;
import net.anwiba.commons.cache.resource.properties.IProperties;
import net.anwiba.commons.lang.object.IObjectContainer;
import net.anwiba.commons.lang.object.ObjectContainer;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceFactory;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.IResourceReferenceVisitor;
import net.anwiba.commons.reference.IResourceReferenceWrapper;
import net.anwiba.commons.reference.utilities.ContentType;
import net.anwiba.commons.reference.utilities.IContentType;
import net.anwiba.commons.reference.utilities.IPrimaryType;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.reference.utilities.PrimaryType;
import net.anwiba.commons.thread.process.IProcessManager;
import net.anwiba.commons.thread.process.ProcessBuilder;

public class ResourceCache
implements IResourceCache {
    private static ILogger logger = Logging.getLogger(ResourceCache.class);
    private final Map<Object, List<IResourceCacheObject>> cachedObjects = new ConcurrentHashMap<Object, List<IResourceCacheObject>>();
    private final IResourceReferenceHandler resourceReferenceHandler;
    private final IResourceReferenceFactory resourceReferenceFactory;
    private final IProcessManager processManager;
    private final List<IResourceCacheConfiguration> configurations;
    private final IResourceCacheConfiguration defaultInMemoryCacheConfiguration = ResourceCacheConfigurationBuilder.builder("memory").acceptor(new BiPredicate<Object, IOptional<IContentType, RuntimeException>>(){
        private final Set<IPrimaryType> supportedPrimaryTypes = Set.of(PrimaryType.TEXT, PrimaryType.APPLICATION);
        private final Set<IContentType> notSupportedContentTypes = Set.of(ContentType.APPLICATION_OGC_SE_XML);

        @Override
        public boolean test(Object key, IOptional<IContentType, RuntimeException> contentType) {
            if (contentType.isEmpty()) {
                return false;
            }
            if (!this.supportedPrimaryTypes.contains(((IContentType)contentType.get()).getPrimaryType())) {
                return false;
            }
            return !this.notSupportedContentTypes.contains(contentType.get());
        }
    }).lifeTime(Duration.ofMinutes(5L)).creationTimeAsStartPointForExpire().weakMemoryAsPreferedCacheStorage().build();

    public ResourceCache(List<IResourceCacheConfiguration> configurations, IProcessManager processManager, IResourceReferenceFactory resourceReferenceFactory, IResourceReferenceHandler resourceReferenceHandler) {
        this.configurations = configurations;
        this.processManager = processManager;
        this.resourceReferenceFactory = resourceReferenceFactory;
        this.resourceReferenceHandler = resourceReferenceHandler;
        this.addToQueue("clean up resource cache", messageCollector -> {
            for (IResourceCacheConfiguration configuration : configurations) {
                if (!configuration.isCleanUpOnStartEnabled()) continue;
                final Duration maximumAgeOnStartupTime = configuration.getMaximumAgeOnStartupTime();
                final ILifeTime lifeTime = configuration.getCachingRule().getPreferedLifeTime();
                final Instant currentTime = Instant.now(Clock.systemDefaultZone());
                final ArrayList filesToDelete = new ArrayList();
                configuration.getCachingFolder().convert(folder -> folder.toPath()).consume(path -> {
                    try {
                        if (!Files.exists(path, new LinkOption[0])) {
                            Files.createDirectories(path, new FileAttribute[0]);
                            return;
                        }
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Duration age = ResourceCache.this.getAge(lifeTime.getStartPointOfTimeMeasuring(), attrs, currentTime);
                                if (age.toMillis() > maximumAgeOnStartupTime.toMillis()) {
                                    filesToDelete.add(file);
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        filesToDelete.forEach(f -> {
                            try {
                                Files.delete(f);
                            }
                            catch (IOException exception) {
                                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                            }
                        });
                    }
                    catch (IOException exception) {
                        logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                    }
                });
            }
        });
        this.addToQueue("clean up resource cache", messageCollector -> {
            Set<Map.Entry<Object, List<IResourceCacheObject>>> entrySet = this.cachedObjects.entrySet();
            for (Map.Entry<Object, List<IResourceCacheObject>> entry : entrySet) {
                List<IResourceCacheObject> objects = entry.getValue();
                if (!this.shouldBeRemoved(objects)) continue;
                this.cachedObjects.remove(entry.getKey());
                objects.forEach(o -> this.remove((IResourceCacheObject)o));
            }
        }, Duration.ofMinutes(1L));
    }

    @Override
    public IResourceReference put(Object key, byte[] data, String contentType, String charset, IProperties properties) {
        return (IResourceReference)this.getConfiguration(key, contentType).convert(configuration -> this.put((IResourceCacheConfiguration)configuration, configuration.getCachingRule(), key, data, contentType, charset, properties)).getOr(() -> this.resourceReferenceFactory.create(data, contentType, charset));
    }

    @Override
    public IResourceReference put(ICachingRule cachingRule, Object key, byte[] data, String contentType, String charset, IProperties properties) {
        return (IResourceReference)this.getConfiguration(cachingRule, key, contentType).convert(configuration -> this.put((IResourceCacheConfiguration)configuration, cachingRule, key, data, contentType, charset, properties)).getOr(() -> this.resourceReferenceFactory.create(data, contentType, charset));
    }

    private IResourceReference put(IResourceCacheConfiguration configuration, ICachingRule cachingRule, Object key, byte[] data, String contentType, String charset, IProperties properties) {
        IResourceReference resourceReference = this.resourceReferenceFactory.create(data, contentType, charset);
        if (data == null || data.length == 0) {
            return resourceReference;
        }
        if (contentType == null || contentType.isBlank()) {
            return resourceReference;
        }
        CacheStorage cacheStorage = this.getCacheStorage(cachingRule, configuration);
        if (Objects.equals((Object)CacheStorage.MEMORY_WEAK, (Object)cacheStorage)) {
            this.put(key, new WeakResourceCacheObject(key, cachingRule.adapt(cacheStorage), resourceReference, contentType, charset, properties));
            return resourceReference;
        }
        if (Objects.equals((Object)CacheStorage.MEMORY_STATIC, (Object)cacheStorage)) {
            this.put(key, new ResourceCacheObject(key, cachingRule.adapt(cacheStorage), resourceReference, contentType, charset, properties));
            return resourceReference;
        }
        ObjectContainer resourceReferenceContainer = new ObjectContainer((Object)resourceReference);
        this.put(key, new ResourceCacheObject(key, cachingRule.adapt(cacheStorage), (IResourceReference)new ResourceReferenceWrapper((IObjectContainer<IResourceReference>)resourceReferenceContainer), contentType, charset, properties));
        this.store(configuration, data, contentType, (ObjectContainer<IResourceReference>)resourceReferenceContainer);
        return resourceReference;
    }

    protected void store(IResourceCacheConfiguration configuration, byte[] data, String contentType, ObjectContainer<IResourceReference> resourceReferenceContainer) {
        this.addToQueue("Store resource into " + configuration.getName() + " cache", messageCollector -> {
            try {
                this.create(configuration, contentType).consume(targetFile -> {
                    try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                        try (FileOutputStream out = new FileOutputStream((File)targetFile);){
                            IoUtilities.pipe((InputStream)in, (OutputStream)out);
                        }
                        resourceReferenceContainer.set((Object)this.resourceReferenceFactory.create(targetFile));
                    }
                }).throwIfFaild();
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResourceCacheObject put(Object key, IResourceCacheObject object) {
        Map<Object, List<IResourceCacheObject>> map = this.cachedObjects;
        synchronized (map) {
            this.cachedObjects.put(key, new LinkedList());
            this.cachedObjects.get(key).add(object);
            return object;
        }
    }

    @Override
    public IResourceReference add(Object key, byte[] data, String contentType, String charset, IProperties properties) {
        return (IResourceReference)this.getConfiguration(key, contentType).convert(configuration -> this.add((IResourceCacheConfiguration)configuration, configuration.getCachingRule(), key, data, contentType, charset, properties)).getOr(() -> this.resourceReferenceFactory.create(data, contentType, charset));
    }

    @Override
    public IResourceReference add(ICachingRule cachingRule, Object key, byte[] data, String contentType, String charset, IProperties properties) {
        return (IResourceReference)this.getConfiguration(cachingRule, key, contentType).convert(configuration -> this.add((IResourceCacheConfiguration)configuration, cachingRule, key, data, contentType, charset, properties)).getOr(() -> this.resourceReferenceFactory.create(data, contentType, charset));
    }

    private IResourceReference add(IResourceCacheConfiguration configuration, ICachingRule cachingRule, Object key, byte[] data, String contentType, String charset, IProperties properties) {
        IResourceReference resourceReference = this.resourceReferenceFactory.create(data, contentType, charset);
        if (data == null || data.length == 0) {
            return resourceReference;
        }
        if (contentType == null || contentType.isBlank()) {
            return resourceReference;
        }
        CacheStorage cacheStorage = this.getCacheStorage(cachingRule, configuration);
        if (Objects.equals((Object)CacheStorage.MEMORY_WEAK, (Object)cacheStorage)) {
            this.add(key, new WeakResourceCacheObject(key, cachingRule.adapt(cacheStorage), resourceReference, contentType, charset, properties));
            return resourceReference;
        }
        if (Objects.equals((Object)CacheStorage.MEMORY_STATIC, (Object)cacheStorage)) {
            this.add(key, new ResourceCacheObject(key, cachingRule.adapt(cacheStorage), resourceReference, contentType, charset, properties));
            return resourceReference;
        }
        ObjectContainer resourceReferenceContainer = new ObjectContainer((Object)resourceReference);
        this.add(key, new ResourceCacheObject(key, cachingRule.adapt(cacheStorage), (IResourceReference)new ResourceReferenceWrapper((IObjectContainer<IResourceReference>)resourceReferenceContainer), contentType, charset, properties));
        this.store(configuration, data, contentType, (ObjectContainer<IResourceReference>)resourceReferenceContainer);
        return resourceReference;
    }

    private CacheStorage getCacheStorage(ICachingRule cachingRule, IResourceCacheConfiguration configuration) {
        CacheStorage configuredCacheStorage = configuration.getCachingRule().getCacheStorage();
        CacheStorage cacheStorage = cachingRule.getCacheStorage();
        if (Objects.equals((Object)CacheStorage.FILE_SYSTEM, (Object)cacheStorage) || Objects.equals((Object)CacheStorage.FILE_SYSTEM, (Object)configuredCacheStorage)) {
            if (configuration.getCachingFolder().isAccepted()) {
                return CacheStorage.FILE_SYSTEM;
            }
            return CacheStorage.MEMORY_STATIC;
        }
        return (CacheStorage)((Object)cachingRule.getMinimumLifeTime().convert(t -> CacheStorage.MEMORY_STATIC).getOr(() -> cacheStorage));
    }

    private IOptional<File, IOException> create(IResourceCacheConfiguration configuration, String contentType) {
        String name = UUID.randomUUID().toString();
        String extension = configuration.getExtensionFor(contentType);
        return configuration.getCachingFolder().convert(folder -> new File((File)folder, name + "." + extension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResourceCacheObject add(Object key, IResourceCacheObject object) {
        Map<Object, List<IResourceCacheObject>> map = this.cachedObjects;
        synchronized (map) {
            this.cachedObjects.putIfAbsent(key, new LinkedList());
            this.cachedObjects.get(key).add(object);
            return object;
        }
    }

    @Override
    public IOptional<IResourceReference, RuntimeException> getResourceReference(Object key) {
        List<IResourceReference> references = this.getResourceReferences(key);
        if (references.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Object)references.get(0));
    }

    @Override
    public List<IResourceReference> getResourceReferences(Object key) {
        return Streams.of((Iterable)this.getObjects(key)).convert(o -> o.getResourceReference()).asList();
    }

    @Override
    public IResourceCacheResult getObject(Object key) {
        IResourceCacheListResult objects = this.getObjects(key);
        if (objects.isEmpty()) {
            return ResourceCacheResult.empty();
        }
        return ResourceCacheResult.of((IResourceCacheObject)objects.toStream().first().get(), objects.isExpired());
    }

    @Override
    public IResourceCacheListResult getObjects(Object key) {
        try {
            List<IResourceCacheObject> list = this.cachedObjects.get(key);
            if (list == null || list.isEmpty()) {
                return ResourceCacheListResult.empty();
            }
            Instant currentTime = Instant.now();
            ArrayList<IResourceCacheObject> result = new ArrayList<IResourceCacheObject>();
            boolean isExpired = false;
            for (IResourceCacheObject object : list) {
                IProperties properties = object.getProperties();
                if (properties == null) {
                    this.remove(key);
                    return ResourceCacheListResult.empty();
                }
                IResourceReference resourceReference = object.getResourceReference();
                if (!this.resourceReferenceHandler.exists(resourceReference)) {
                    this.remove(key);
                    return ResourceCacheListResult.empty();
                }
                ICachingRule cachingRule = object.getCachingRule();
                IResourceCacheConfiguration configuration = (IResourceCacheConfiguration)this.getConfiguration(cachingRule, key, object.getContentType()).get();
                ObjectPair<Boolean, ResourceAge> expired = this.isExpired(configuration, resourceReference, cachingRule, currentTime);
                boolean bl = isExpired = isExpired && (Boolean)expired.getFirstObject() != false;
                if (isExpired) {
                    if (this.shouldBeRemoved(cachingRule, (ResourceAge)expired.getSecondObject(), currentTime)) {
                        this.remove(key);
                        return ResourceCacheListResult.empty();
                    }
                    if (!this.canBeUsed(cachingRule, (ResourceAge)expired.getSecondObject(), configuration, currentTime)) {
                        return ResourceCacheListResult.empty();
                    }
                }
                result.add(object instanceof WeakResourceCacheObject ? new ResourceCacheObject(key, cachingRule, resourceReference, object.getContentType(), object.getCharset(), properties) : object);
            }
            return ResourceCacheListResult.of(result, isExpired);
        }
        catch (NullPointerException exception) {
            this.remove(key);
            return ResourceCacheListResult.empty();
        }
    }

    private boolean canBeUsed(ICachingRule cachingRule, ResourceAge age, IResourceCacheConfiguration configuration, Instant currentTime) {
        return age != null && (Boolean)cachingRule.getMaximumLifeTime().convert(lifeTime -> age.getAge(currentTime, lifeTime.getStartPointOfTimeMeasuring()).toMillis() > lifeTime.getDuration().minus(configuration.getLatencyTime()).toMillis()).getOr(() -> false) == false;
    }

    private boolean shouldBeRemoved(List<IResourceCacheObject> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        Instant currentTime = Instant.now(Clock.systemDefaultZone());
        for (IResourceCacheObject object : list) {
            if (object.getProperties() == null) {
                return true;
            }
            ObjectPair<Boolean, ResourceAge> expired = this.isExpired((IResourceCacheConfiguration)this.getConfiguration(object.getCachingRule(), object.getKey(), object.getContentType()).get(), object, currentTime);
            if (!this.shouldBeRemoved(object.getCachingRule(), (ResourceAge)expired.getSecondObject(), currentTime)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldBeRemoved(ICachingRule cachingRule, ResourceAge resourceAge, Instant currentTime) {
        if (resourceAge == null) {
            return true;
        }
        boolean isExpired = this.isExpired(resourceAge, cachingRule.getPreferedLifeTime(), currentTime);
        if (cachingRule.getMaximumLifeTime().isEmpty() && cachingRule.getMinimumLifeTime().isEmpty() && isExpired) {
            return true;
        }
        if (((Boolean)cachingRule.getMaximumLifeTime().convert(lifeTime -> this.isExpired(resourceAge, (ILifeTime)lifeTime, currentTime)).getOr(() -> false)).booleanValue()) {
            return true;
        }
        if (cachingRule.getMinimumLifeTime().isEmpty() && isExpired) {
            return true;
        }
        return (Boolean)cachingRule.getMinimumLifeTime().convert(lifeTime -> this.isExpired(resourceAge, (ILifeTime)lifeTime, currentTime) && cachingRule.getCacheStorage().isMemory()).getOr(() -> false) != false || isExpired;
    }

    protected boolean isExpired(ResourceAge resourceAge, ILifeTime lifeTime, Instant currentTime) {
        return resourceAge.getAge(currentTime, lifeTime.getStartPointOfTimeMeasuring()).toMillis() > lifeTime.getDuration().toMillis();
    }

    private ObjectPair<Boolean, ResourceAge> isExpired(IResourceCacheConfiguration configuration, IResourceCacheObject object, Instant currentTime) {
        return this.isExpired(configuration, object.getResourceReference(), object.getCachingRule(), currentTime);
    }

    private ObjectPair<Boolean, ResourceAge> isExpired(IResourceCacheConfiguration configuration, IResourceReference resourceReference, ICachingRule cachingRule, Instant currentTime) {
        if (resourceReference == null) {
            return ObjectPair.of((Object)true, null);
        }
        if (!this.resourceReferenceHandler.exists(resourceReference)) {
            return ObjectPair.of((Object)true, null);
        }
        ResourceAge fileAge = new ResourceAge(this.resourceReferenceHandler, resourceReference);
        return (ObjectPair)cachingRule.getMaximumLifeTime().convert(lifeTime -> this.isExpired(configuration, fileAge, (ILifeTime)lifeTime, currentTime)).getOr(() -> (ObjectPair)cachingRule.getMinimumLifeTime().convert(lifeTime -> this.isExpired(configuration, fileAge, (ILifeTime)lifeTime, currentTime)).getOr(() -> this.isExpired(configuration, fileAge, cachingRule.getPreferedLifeTime(), currentTime)));
    }

    private ObjectPair<Boolean, ResourceAge> isExpired(IResourceCacheConfiguration configuration, ResourceAge fileAge, ILifeTime lifeTime, Instant currentTime) {
        Duration age = fileAge.getAge(currentTime, lifeTime.getStartPointOfTimeMeasuring());
        return ObjectPair.of((Object)(age.toMillis() > lifeTime.getDuration().minus(configuration.getLatencyTime()).toMillis() ? 1 : 0), (Object)fileAge);
    }

    private void remove(IResourceCacheObject object) {
        try {
            IResourceReference resourceReference = object.getResourceReference();
            if (this.resourceReferenceHandler.canDelete(resourceReference)) {
                this.resourceReferenceHandler.delete(resourceReference);
            }
        }
        catch (IOException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void remove(Object key) {
        List<IResourceCacheObject> objects = this.cachedObjects.get(key);
        this.cachedObjects.remove(key);
        if (objects == null || objects.isEmpty()) {
            return;
        }
        this.addToQueue("Remove resource from resource cache", messageCollector -> objects.forEach(o -> this.remove((IResourceCacheObject)o)));
    }

    @Override
    public void clear() {
        List<IResourceCacheObject> objects = this.cachedObjects.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        this.cachedObjects.clear();
        objects.forEach(o -> this.remove((IResourceCacheObject)o));
    }

    private Duration getAge(ResourceAccessEvent pointOfTime, BasicFileAttributes attrs, Instant currentTime) {
        FileTime time = this.getTime(pointOfTime, attrs);
        return Duration.between(time.toInstant(), currentTime);
    }

    private FileTime getTime(ResourceAccessEvent pointOfTime, BasicFileAttributes attributes) {
        switch (pointOfTime) {
            case CREATED: {
                return attributes.creationTime();
            }
            case LAST_MODIFIED: {
                return attributes.lastModifiedTime();
            }
            case LAST_ACCESS: {
                return attributes.lastAccessTime();
            }
        }
        return FileTime.from(0L, TimeUnit.SECONDS);
    }

    private IOptional<IResourceCacheConfiguration, RuntimeException> getConfiguration(ICachingRule cachingRule, Object key, String contentType) {
        return Optional.of((Object)((IResourceCacheConfiguration)this.getConfiguration(key, contentType).getOr(() -> !Objects.equals((Object)cachingRule.getCacheStorage(), (Object)CacheStorage.FILE_SYSTEM) ? (this.defaultInMemoryCacheConfiguration.isApplicable(key, contentType) ? this.defaultInMemoryCacheConfiguration : null) : null)));
    }

    private IOptional<IResourceCacheConfiguration, RuntimeException> getConfiguration(Object key, String contentType) {
        return Streams.of(this.configurations).first(c -> c.isApplicable(key, contentType));
    }

    private void addToQueue(String description, Consumer<IMessageCollector> executor) {
        this.addToQueue(description, executor, null);
    }

    private void addToQueue(String description, Consumer<IMessageCollector> executor, Duration delay) {
        this.processManager.execute(new ProcessBuilder().setQueueName("CACHE_WRITER").setDescription(description).setCancelable(false).setDelay(delay).setExecutable((monitor, canceler, processIdentfier) -> executor.accept(monitor)).build());
    }

    private static class ResourceReferenceWrapper
    implements IResourceReferenceWrapper {
        private final IObjectContainer<IResourceReference> resourceReferenceContainer;

        public ResourceReferenceWrapper(IObjectContainer<IResourceReference> resourceReferenceContainer) {
            this.resourceReferenceContainer = resourceReferenceContainer;
        }

        public <O, E extends Exception> O accept(IResourceReferenceVisitor<O, E> visitor) throws E {
            return (O)visitor.visitWrappedReference((IResourceReferenceWrapper)this);
        }

        public IResourceReference getWrappedResourceReference() {
            return (IResourceReference)this.resourceReferenceContainer.get();
        }
    }

    private static class ResourceAge {
        private FileTime lastAccessed;
        private FileTime lastModified;
        private FileTime creationTime;
        private final IResourceReferenceHandler resourceReferenceHandler;
        private final IResourceReference resourceReference;

        public ResourceAge(IResourceReferenceHandler resourceReferenceHandler, IResourceReference resourceReference) {
            this.resourceReferenceHandler = resourceReferenceHandler;
            this.resourceReference = resourceReference;
        }

        public FileTime creationTime() {
            if (this.creationTime == null) {
                try {
                    this.creationTime = this.resourceReferenceHandler.created(this.resourceReference);
                }
                catch (IOException exception) {
                    this.creationTime = FileTime.from(0L, TimeUnit.SECONDS);
                }
            }
            return this.creationTime;
        }

        public FileTime lastModified() {
            if (this.lastModified == null) {
                try {
                    this.lastModified = this.resourceReferenceHandler.created(this.resourceReference);
                }
                catch (IOException exception) {
                    this.lastModified = FileTime.from(0L, TimeUnit.SECONDS);
                }
            }
            return this.lastModified;
        }

        public FileTime lastAccessed() {
            if (this.lastAccessed == null) {
                try {
                    this.lastAccessed = this.resourceReferenceHandler.lastAccessed(this.resourceReference);
                }
                catch (IOException exception) {
                    this.lastAccessed = FileTime.from(0L, TimeUnit.SECONDS);
                }
            }
            return this.lastAccessed;
        }

        public Duration getAge(Instant now, ResourceAccessEvent event) {
            return Duration.between(this.getTime(event).toInstant(), now);
        }

        private FileTime getTime(ResourceAccessEvent event) {
            switch (event) {
                case CREATED: {
                    return this.creationTime();
                }
                case LAST_MODIFIED: {
                    return this.lastModified();
                }
                case LAST_ACCESS: {
                    return this.lastAccessed();
                }
            }
            return FileTime.from(0L, TimeUnit.SECONDS);
        }
    }
}

