/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.anwiba.commons.cache.resource.CacheStorage;
import net.anwiba.commons.cache.resource.CachingRule;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.cache.resource.IResourceCacheConfiguration;
import net.anwiba.commons.cache.resource.LifeTime;
import net.anwiba.commons.cache.resource.ResourceAccessEvent;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.utilities.ContentType;
import net.anwiba.commons.reference.utilities.IContentType;

public class ResourceCacheConfigurationBuilder {
    private String name;
    private BiPredicate<Object, IOptional<IContentType, RuntimeException>> acceptor = (key, contentType) -> true;
    private File cachingFolder = null;
    private Duration lifeTime = Duration.ofMinutes(5L);
    private ResourceAccessEvent pointOfTimeToExpire = ResourceAccessEvent.LAST_ACCESS;
    private CacheStorage preferedCacheStorage = null;

    public static ResourceCacheConfigurationBuilder builder(String name) {
        return new ResourceCacheConfigurationBuilder(name);
    }

    public ResourceCacheConfigurationBuilder(String name) {
        this.name = name;
    }

    public ResourceCacheConfigurationBuilder acceptor(BiPredicate<Object, IOptional<IContentType, RuntimeException>> acceptor) {
        this.acceptor = acceptor;
        return this;
    }

    public ResourceCacheConfigurationBuilder lifeTime(Duration lifeTime) {
        this.lifeTime = lifeTime;
        return this;
    }

    public ResourceCacheConfigurationBuilder creationTimeAsStartPointForExpire() {
        this.pointOfTimeToExpire = ResourceAccessEvent.CREATED;
        return this;
    }

    public ResourceCacheConfigurationBuilder startPointForExpire(ResourceAccessEvent pointOfFileTime) {
        this.pointOfTimeToExpire = pointOfFileTime;
        return this;
    }

    public ResourceCacheConfigurationBuilder lastModifiedAsStartPointForExpire() {
        this.pointOfTimeToExpire = ResourceAccessEvent.LAST_MODIFIED;
        return this;
    }

    public ResourceCacheConfigurationBuilder lastAccessAsStartPointForExpire() {
        this.pointOfTimeToExpire = ResourceAccessEvent.LAST_ACCESS;
        return this;
    }

    public ResourceCacheConfigurationBuilder preferedCacheStorage(CacheStorage preferedCacheStorage) {
        this.preferedCacheStorage = preferedCacheStorage;
        return this;
    }

    public ResourceCacheConfigurationBuilder weakMemoryAsPreferedCacheStorage() {
        this.preferedCacheStorage = CacheStorage.MEMORY_WEAK;
        return this;
    }

    public ResourceCacheConfigurationBuilder staticMemoryAsPreferedCacheStorage() {
        this.preferedCacheStorage = CacheStorage.MEMORY_STATIC;
        return this;
    }

    public ResourceCacheConfigurationBuilder fileSystemAsPreferedCacheStorage() {
        this.preferedCacheStorage = CacheStorage.FILE_SYSTEM;
        return this;
    }

    public ResourceCacheConfigurationBuilder cachingFolder(File cachingFolder) {
        this.cachingFolder = cachingFolder;
        return this;
    }

    private ICachingRule createCachingRule() {
        return CachingRule.of(LifeTime.of(this.lifeTime, this.pointOfTimeToExpire), this.preferedCacheStorage);
    }

    private IOptional<File, IOException> cachingFolder() {
        if (Objects.equals((Object)this.preferedCacheStorage, (Object)CacheStorage.FILE_SYSTEM)) {
            try {
                return Optional.of(IOException.class, (Object)((File)Optional.of(IOException.class, (Object)this.cachingFolder).getOr(() -> new File(Files.createTempDirectory("resourcecache", new FileAttribute[0]).toFile(), this.name))));
            }
            catch (IOException exception) {
                return Optional.failed(IOException.class, (Exception)exception);
            }
        }
        return Optional.of(IOException.class, (Object)this.cachingFolder);
    }

    public IResourceCacheConfiguration build() {
        final ICachingRule cachingRule = this.createCachingRule();
        final IOptional<File, IOException> cachingFolder = this.cachingFolder();
        return new IResourceCacheConfiguration(){

            @Override
            public boolean isApplicable(Object key, String contentType) {
                return ResourceCacheConfigurationBuilder.this.acceptor.test(key, (IOptional<IContentType, RuntimeException>)ContentType.from((String)contentType));
            }

            @Override
            public String getName() {
                return ResourceCacheConfigurationBuilder.this.name;
            }

            @Override
            public ICachingRule getCachingRule() {
                return cachingRule;
            }

            @Override
            public IOptional<File, IOException> getCachingFolder() {
                return cachingFolder;
            }
        };
    }
}

