/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.anwiba.commons.cache.resource.IResourceCacheListResult;
import net.anwiba.commons.cache.resource.IResourceCacheObject;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.Streams;

public class ResourceCacheListResult
implements IResourceCacheListResult {
    private List<IResourceCacheObject> objects;
    private boolean isExpired;

    public ResourceCacheListResult(List<IResourceCacheObject> objects, boolean isExpired) {
        this.objects = objects;
        this.isExpired = isExpired;
    }

    public static IResourceCacheListResult empty() {
        return new ResourceCacheListResult(List.of(), true);
    }

    public static IResourceCacheListResult of(List<IResourceCacheObject> objects, boolean isExpired) {
        return new ResourceCacheListResult(objects, isExpired);
    }

    @Override
    public Iterator<IResourceCacheObject> iterator() {
        return new ArrayList<IResourceCacheObject>(this.objects).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public boolean isExpired() {
        return this.isExpired;
    }

    @Override
    public IStream<IResourceCacheObject, RuntimeException> toStream() {
        return Streams.of(this.objects);
    }

    @Override
    public int size() {
        return this.objects.size();
    }
}

