/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.io.Serializable;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.cache.resource.IResourceCacheObject;
import net.anwiba.commons.cache.resource.properties.IProperties;
import net.anwiba.commons.reference.IResourceReference;

public final class ResourceCacheObject
implements IResourceCacheObject {
    private final Object key;
    private final ICachingRule cachingRule;
    private final IResourceReference resourceReference;
    private final String contentType;
    private final String charset;
    private IProperties properties;

    public ResourceCacheObject(Object key, ICachingRule lifeTime, IResourceReference resourceReference, String contentType, String charset, IProperties properties) {
        this.key = key;
        this.cachingRule = lifeTime;
        this.resourceReference = resourceReference;
        this.properties = properties;
        this.contentType = contentType;
        this.charset = charset;
    }

    @Override
    public ICachingRule getCachingRule() {
        return this.cachingRule;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public IResourceReference getResourceReference() {
        return this.resourceReference;
    }

    @Override
    public <T extends Serializable> T getPropertyValue(String name) {
        return this.properties.getValue(name);
    }

    @Override
    public IProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

