/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anwiba.commons.cache.resource.CachingRule;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.cache.resource.IResourceCache;
import net.anwiba.commons.cache.resource.IResourceCacheListResult;
import net.anwiba.commons.cache.resource.IResourceCacheObject;
import net.anwiba.commons.cache.resource.IResourceCacheResult;
import net.anwiba.commons.cache.resource.LifeTime;
import net.anwiba.commons.cache.resource.ResourceCacheListResult;
import net.anwiba.commons.cache.resource.ResourceCacheResult;
import net.anwiba.commons.cache.resource.WeakResourceCacheObject;
import net.anwiba.commons.cache.resource.properties.IProperties;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceFactory;
import net.anwiba.commons.reference.IResourceReferenceHandler;

public class WeakInMemoryResourceCache
implements IResourceCache {
    private final Map<Object, List<IResourceCacheObject>> objects = new ConcurrentHashMap<Object, List<IResourceCacheObject>>();
    private final ICachingRule cachingRule;
    private final IResourceReferenceHandler resourceReferenceHandler;
    private final IResourceReferenceFactory resourceReferenceFactory;

    public WeakInMemoryResourceCache(IResourceReferenceFactory resourceReferenceFactory, IResourceReferenceHandler resourceReferenceHandler, long lifeTime) {
        this.resourceReferenceFactory = resourceReferenceFactory;
        this.resourceReferenceHandler = resourceReferenceHandler;
        this.cachingRule = CachingRule.of(LifeTime.of(lifeTime));
    }

    @Override
    public IResourceReference put(Object key, byte[] data, String contentType, String charset, IProperties properties) {
        return this.put(this.cachingRule, key, data, contentType, charset, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResourceReference put(ICachingRule cachingRule, Object key, byte[] data, String contentType, String charset, IProperties properties) {
        IResourceReference resourceReference = this.resourceReferenceFactory.create(data, contentType, charset);
        if (data == null || data.length == 0) {
            return resourceReference;
        }
        if (contentType == null || contentType.isBlank()) {
            return resourceReference;
        }
        Map<Object, List<IResourceCacheObject>> map = this.objects;
        synchronized (map) {
            this.objects.put(key, new LinkedList());
            this.objects.get(key).add(new WeakResourceCacheObject(key, cachingRule, resourceReference, contentType, charset, properties));
            return resourceReference;
        }
    }

    @Override
    public IResourceReference add(Object key, byte[] data, String contentType, String charset, IProperties properties) {
        return this.add(this.cachingRule, key, data, contentType, charset, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResourceReference add(ICachingRule cachingRule, Object key, byte[] data, String contentType, String charset, IProperties properties) {
        IResourceReference resourceReference = this.resourceReferenceFactory.create(data, contentType, charset);
        if (data == null || data.length == 0) {
            return resourceReference;
        }
        if (contentType == null || contentType.isBlank()) {
            return resourceReference;
        }
        Map<Object, List<IResourceCacheObject>> map = this.objects;
        synchronized (map) {
            this.objects.putIfAbsent(key, new LinkedList());
            this.objects.get(key).add(new WeakResourceCacheObject(key, cachingRule, resourceReference, contentType, charset, properties));
            return resourceReference;
        }
    }

    @Override
    public IOptional<IResourceReference, RuntimeException> getResourceReference(Object key) {
        List<IResourceReference> references = this.getResourceReferences(key);
        if (references.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Object)references.get(0));
    }

    @Override
    public List<IResourceReference> getResourceReferences(Object key) {
        return Streams.of((Iterable)this.getObjects(key)).convert(o -> o.getResourceReference()).asList();
    }

    @Override
    public IResourceCacheResult getObject(Object key) {
        IResourceCacheListResult objects = this.getObjects(key);
        if (objects.isEmpty()) {
            return ResourceCacheResult.empty();
        }
        return ResourceCacheResult.of((IResourceCacheObject)objects.toStream().first().get(), false);
    }

    @Override
    public IResourceCacheListResult getObjects(Object key) {
        try {
            List<IResourceCacheObject> list = this.objects.get(key);
            if (list == null || list.isEmpty()) {
                return ResourceCacheListResult.empty();
            }
            for (IResourceCacheObject object : list) {
                Duration objectLifeTime = object.getCachingRule().getPreferedLifeTime().getDuration();
                IResourceReference resourceReference = object.getResourceReference();
                if (!this.isExpired(resourceReference, objectLifeTime)) continue;
                this.remove(key);
                return ResourceCacheListResult.empty();
            }
            return ResourceCacheListResult.of(list, false);
        }
        catch (NullPointerException exception) {
            this.remove(key);
            return ResourceCacheListResult.empty();
        }
    }

    private boolean isExpired(IResourceReference resourceReference, Duration objectLifeTime) {
        try {
            if (resourceReference == null) {
                return true;
            }
            if (!this.resourceReferenceHandler.exists(resourceReference)) {
                return true;
            }
            FileTime lastModified = this.resourceReferenceHandler.lastModified(resourceReference);
            Instant currentTime = Instant.now(Clock.systemDefaultZone());
            Duration age = Duration.between(lastModified.toInstant(), currentTime);
            return age.toMillis() > objectLifeTime.toMillis();
        }
        catch (IOException exception) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.objects.clear();
    }

    @Override
    public void remove(Object key) {
        this.objects.remove(key);
    }
}

