/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import net.anwiba.commons.cache.resource.ICachingRule;
import net.anwiba.commons.cache.resource.IResourceCacheObject;
import net.anwiba.commons.cache.resource.properties.IProperties;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.IResourceReference;

public final class WeakResourceCacheObject
implements IResourceCacheObject {
    private final Object key;
    private final WeakReference<ObjectPair<IResourceReference, IProperties>> reference;
    private final String contentType;
    private final String charset;
    private final ICachingRule cachingRule;

    public WeakResourceCacheObject(Object key, ICachingRule cachingRule, IResourceReference resourceReference, String contentType, String charset, IProperties properties) {
        this.key = key;
        this.cachingRule = cachingRule;
        this.contentType = contentType;
        this.charset = charset;
        this.reference = new WeakReference<ObjectPair>(ObjectPair.of((Object)resourceReference, (Object)properties));
    }

    @Override
    public ICachingRule getCachingRule() {
        return this.cachingRule;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public IResourceReference getResourceReference() {
        return (IResourceReference)Optional.of((Object)((ObjectPair)this.reference.get())).convert(p -> (IResourceReference)p.getFirstObject()).get();
    }

    @Override
    public <T extends Serializable> T getPropertyValue(String name) {
        return (T)((Serializable)Optional.of((Object)((ObjectPair)this.reference.get())).convert(p -> (IProperties)p.getSecondObject()).convert(p -> p.getValue(name)).get());
    }

    @Override
    public IProperties getProperties() {
        return (IProperties)Optional.of((Object)((ObjectPair)this.reference.get())).convert(p -> (IProperties)p.getSecondObject()).get();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

