/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.cache.resource.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.cache.resource.properties.IProperties;
import net.anwiba.commons.cache.resource.properties.IProperty;
import net.anwiba.commons.cache.resource.properties.PropertiesBuilder;
import net.anwiba.commons.lang.stream.Streams;

public final class Properties
implements IProperties {
    private final List<String> names = new ArrayList<String>();
    private final List<IProperty> properties = new ArrayList<IProperty>();
    private final Map<String, IProperty> map = new HashMap<String, IProperty>();

    public static IProperties empty() {
        return Properties.builder().build();
    }

    public static PropertiesBuilder builder() {
        return new PropertiesBuilder();
    }

    public Properties(List<IProperty> properties) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (IProperty property2 : properties) {
            names.add(property2.getName());
            this.map.put(property2.getName(), property2);
        }
        this.names.addAll(names);
        Streams.of(names).convert(name -> this.map.get(name)).notNull().foreach(property -> this.properties.add((IProperty)property));
    }

    @Override
    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public <T extends Serializable> T getValue(String name) {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public Iterator<IProperty> iterator() {
        return this.properties.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

