/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.resource.reference.FileResourceReference;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceFactory;
import net.anwiba.commons.resource.reference.IResourceReferenceHandler;
import net.anwiba.commons.resource.reference.IResourceReferenceVisitor;
import net.anwiba.commons.resource.reference.IStreamConnector;
import net.anwiba.commons.resource.reference.MemoryResourceReference;
import net.anwiba.commons.resource.reference.ResourceReferenceFactory;
import net.anwiba.commons.resource.reference.ResourceReferenceUtilities;
import net.anwiba.commons.resource.reference.UriResourceReference;
import net.anwiba.commons.resource.reference.UrlResourceReference;
import net.anwiba.commons.resource.utilities.IoUtilities;
import net.anwiba.commons.resource.utilities.UriToUrlConverter;
import net.anwiba.commons.resource.utilities.UrlStreamConnector;
import net.anwiba.commons.resource.utilities.UrlToUriConverter;

public class ResourceReferenceHandler
implements IResourceReferenceHandler {
    private static final String ENCODING = "UTF-8";
    final IStreamConnector<URI> connector;
    final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
    final UriToUrlConverter uriToUrlConverter = new UriToUrlConverter();
    final IResourceReferenceFactory factory = new ResourceReferenceFactory();

    public ResourceReferenceHandler() {
        this(new UrlStreamConnector());
    }

    public ResourceReferenceHandler(IStreamConnector<URI> connector) {
        this.connector = connector;
    }

    @Override
    public File getFile(IResourceReference resourceReference) throws URISyntaxException {
        return ResourceReferenceUtilities.getFile(resourceReference);
    }

    @Override
    public URL getUrl(IResourceReference resourceReference) throws MalformedURLException {
        return ResourceReferenceUtilities.getUrl(resourceReference);
    }

    @Override
    public URI getUri(IResourceReference resourceReference) throws URISyntaxException {
        return ResourceReferenceUtilities.getUri(resourceReference);
    }

    @Override
    public String getExtension(IResourceReference resourceReference) {
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.getExtension(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return ResourceReferenceUtilities.getExtension(resourceReference);
    }

    @Override
    public OutputStream openOnputStream(IResourceReference resourceReference) throws IOException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.openOnputStream(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return resourceReference.accept(new IResourceReferenceVisitor<OutputStream, IOException>(){

            @Override
            public OutputStream visitUrlResource(UrlResourceReference urlResourceReference) throws IOException {
                try {
                    return ResourceReferenceHandler.this.connector.openOutputStream(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException exception) {
                    throw new IOException(exception);
                }
            }

            @Override
            public OutputStream visitUriResource(UriResourceReference uriResourceReference) throws IOException {
                return ResourceReferenceHandler.this.connector.openOutputStream(uriResourceReference.getUri());
            }

            @Override
            public OutputStream visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return new FileOutputStream(fileResourceReference.getFile());
            }

            @Override
            public OutputStream visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                throw new IOException("not yet supported for InMemoryResources resources");
            }
        });
    }

    @Override
    public InputStream openInputStream(IResourceReference resourceReference) throws IOException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.openInputStream(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return resourceReference.accept(new IResourceReferenceVisitor<InputStream, IOException>(){

            @Override
            public InputStream visitUrlResource(UrlResourceReference urlResourceReference) throws IOException {
                try {
                    return ResourceReferenceHandler.this.connector.openInputStream(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException exception) {
                    throw new IOException(exception);
                }
            }

            @Override
            public InputStream visitUriResource(UriResourceReference uriResourceReference) throws IOException {
                return ResourceReferenceHandler.this.connector.openInputStream(uriResourceReference.getUri());
            }

            @Override
            public InputStream visitFileResource(FileResourceReference fileResourceReference) throws IOException {
                return new FileInputStream(fileResourceReference.getFile());
            }

            @Override
            public InputStream visitMemoryResource(MemoryResourceReference memoryResourceReference) throws IOException {
                return new ByteArrayInputStream(memoryResourceReference.getBuffer());
            }
        });
    }

    @Override
    public boolean exsits(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.exsits(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.exist(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException uRISyntaxException) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) {
                return ResourceReferenceHandler.this.connector.exist(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                File file = fileResourceReference.getFile();
                return Files.exists(file.toPath(), new LinkOption[0]);
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public boolean canRead(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.canRead(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.canRead(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException uRISyntaxException) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) {
                return ResourceReferenceHandler.this.connector.canRead(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().canRead();
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public boolean canWrite(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.canWrite(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.canWrite(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (URISyntaxException uRISyntaxException) {
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) {
                return ResourceReferenceHandler.this.connector.canWrite(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().canRead();
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public boolean hasLocation(IResourceReference resourceReference) {
        return ResourceReferenceUtilities.hasLocation(resourceReference);
    }

    @Override
    public String getContent(IResourceReference resourceReference) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = this.openInputStream(resourceReference);){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IoUtilities.pipe(inputStream, outputStream);
            return outputStream.toString(ENCODING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isFileSystemResource(IResourceReference resourceReference) {
        return ResourceReferenceUtilities.isFileSystemResource(resourceReference);
    }

    @Override
    public long getContentLength(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return 0L;
        }
        if (!(resourceReference instanceof FileResourceReference) && this.isFileSystemResource(resourceReference)) {
            try {
                return this.getContentLength(this.factory.create(this.getFile(resourceReference)));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Long, RuntimeException>(){

            @Override
            public Long visitUrlResource(UrlResourceReference urlResourceReference) {
                try {
                    return ResourceReferenceHandler.this.connector.getContentLength(ResourceReferenceHandler.this.getUri(urlResourceReference));
                }
                catch (IOException | URISyntaxException exception) {
                    return -1L;
                }
            }

            @Override
            public Long visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                try {
                    return ResourceReferenceHandler.this.connector.getContentLength(uriResourceReference.getUri());
                }
                catch (IOException iOException) {
                    return -1L;
                }
            }

            @Override
            public Long visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().length();
            }

            @Override
            public Long visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return memoryResourceReference.getBuffer().length;
            }
        });
    }

    @Override
    public boolean canDelete(IResourceReference resourceReference) {
        try {
            return (Boolean)this.ifFile(resourceReference).convert(input -> this.canDelete((File)input)).getOr(() -> Boolean.FALSE);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void delete(IResourceReference resourceReference) throws IOException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        File file = (File)this.ifFile(resourceReference).getOrThrow(() -> new IOException("not yet supported for '" + this.toString(resourceReference) + "' resources"));
        if (!this.canDelete(file)) {
            throw new IOException("insufficient privileges");
        }
        Path directory = file.toPath();
        if (file.isDirectory()) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path folder, IOException exception) throws IOException {
                    if (exception != null) {
                        throw exception;
                    }
                    Files.delete(folder);
                    return FileVisitResult.CONTINUE;
                }
            });
            return;
        }
        Files.deleteIfExists(file.toPath());
    }

    private boolean canDelete(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = java.util.Optional.ofNullable(file.listFiles()).orElseGet(() -> new File[0]);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (!this.canDelete(child)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected IOptional<File, IOException> ifFile(IResourceReference resourceReference) throws IOException {
        return Optional.create((Object)resourceReference).accept(r -> this.isFileSystemResource(resourceReference)).convert(r -> {
            try {
                return this.getFile(resourceReference);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException();
            }
        });
    }

    @Override
    public String toString(IResourceReference resourceReference) {
        return ResourceReferenceUtilities.toString(resourceReference);
    }
}

