/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reflaction;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.resource.annotation.Encoding;
import net.anwiba.commons.resource.annotation.Location;
import net.anwiba.commons.resource.annotation.Static;
import net.anwiba.commons.resource.reflaction.FieldValueFactory;
import net.anwiba.commons.resource.reflaction.IResourceProvider;

public abstract class AbstractResourceFactory {
    static ILogger logger = Logging.getLogger((String)AbstractResourceFactory.class.getName());
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static final String EXTENSION = "txt";
    private static final Object ASSIGNED = new Object();
    private static final FieldValueFactory fieldValueFactory = new FieldValueFactory();

    public static void initialize(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            AbstractResourceFactory.load(clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AbstractResourceFactory.load(clazz);
                return null;
            }
        });
    }

    static void load(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        Map<String, Object> fields = AbstractResourceFactory.buildFieldsMap(fieldArray);
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        String rootPath = AbstractResourceFactory.createRootPath(clazz);
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            String resourceUrl = AbstractResourceFactory.createResourceUrl(rootPath, field);
            Object fieldObject = fields.put(field.getName(), ASSIGNED);
            if (fieldObject == null) {
                String msg = "unused statement: " + field.getName();
                logger.log(ILevel.DEBUG, msg);
            } else if (fieldObject != ASSIGNED) {
                AbstractResourceFactory.setValue(field, isAccessible, resourceUrl);
            }
            ++n2;
        }
        AbstractResourceFactory.computeMissingBinding(clazz.getName(), fields, fieldArray, isAccessible);
    }

    private static String createRootPath(Class<?> clazz) {
        return clazz.getPackage().getName().replace('.', '/');
    }

    private static String createResourceUrl(String pathRoot, Field field) {
        Location annotation = field.getAnnotation(Location.class);
        if (annotation != null) {
            String value = annotation.value();
            if (value.toLowerCase().startsWith("file:") || value.toLowerCase().startsWith("http:")) {
                return value;
            }
            if (AbstractResourceFactory.isAbsolute(value)) {
                return value.substring(1, value.length());
            }
            return MessageFormat.format("{0}/{1}", pathRoot, value);
        }
        return MessageFormat.format("{0}/{1}.{2}", pathRoot, field.getName(), AbstractResourceFactory.getExtention(field));
    }

    private static boolean isAbsolute(String value) {
        return value.startsWith("/");
    }

    private static String getExtention(Field field) {
        try {
            Class<?> clazz = Class.forName(field.getType().getName());
            if (IResourceProvider.class.isAssignableFrom(clazz)) {
                Method method = clazz.getDeclaredMethod("getExtention", new Class[0]);
                return (String)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            return EXTENSION;
        }
        return EXTENSION;
    }

    private static void computeMissingBinding(String bundleName, Map<String, Object> fieldsMap, Field[] fieldArray, boolean isAccessible) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && fieldsMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "resource reader missing binding for: " + field.getName() + " in: " + bundleName;
                    logger.log(ILevel.DEBUG, value);
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    AbstractResourceFactory.setMessage(field, value);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.log(ILevel.ERROR, "Error setting the binding value for: " + field.getName(), (Throwable)e);
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
            ++i;
        }
    }

    public static void setMessage(Field field, String message) {
        try {
            Class<?> type = field.getType();
            Class<?> clazz = Class.forName(type.getName());
            if (IResourceProvider.class.isAssignableFrom(clazz)) {
                throw new RuntimeException(message);
            }
            if (IResourceReference.class.equals(clazz)) {
                throw new RuntimeException(message);
            }
            if (type.isArray()) {
                throw new RuntimeException(message);
            }
            field.set(null, message);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        catch (IllegalArgumentException exception) {
            throw new RuntimeException(exception);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Map<String, Object> buildFieldsMap(Field[] fieldArray) {
        HashMap<String, Object> fields = new HashMap<String, Object>(fieldArray.length * 2);
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            fields.put(field.getName(), field);
            ++n2;
        }
        return fields;
    }

    private static synchronized void setValue(Field field, boolean isAccessible, String resourceUrl) {
        if ((field.getModifiers() & 0x19) != 9) {
            return;
        }
        try {
            Object result = fieldValueFactory.create(field.getType(), AbstractResourceFactory.isStatic(field), resourceUrl, AbstractResourceFactory.getCharset(field));
            if (!isAccessible) {
                field.setAccessible(true);
            }
            field.set(null, result);
        }
        catch (InvocationTargetException e) {
            logger.log(ILevel.ERROR, "Exception setting field value.", e.getCause());
        }
        catch (IllegalAccessException e) {
            logger.log(ILevel.ERROR, "Exception setting field value.", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.log(ILevel.ERROR, "Exception setting field value.", (Throwable)e);
        }
    }

    private static boolean isStatic(Field field) {
        Static staticAnnotation = field.getAnnotation(Static.class);
        return staticAnnotation != null ? staticAnnotation.value() : true;
    }

    private static Charset getCharset(Field field) {
        Encoding annotation = field.getAnnotation(Encoding.class);
        try {
            return Charset.forName(annotation != null ? annotation.value() : "UTF-8");
        }
        catch (UnsupportedCharsetException exception) {
            logger.log(ILevel.ERROR, exception.getLocalizedMessage(), (Throwable)exception);
            return Charset.forName("UTF-8");
        }
        catch (IllegalCharsetNameException exception) {
            logger.log(ILevel.ERROR, exception.getLocalizedMessage(), (Throwable)exception);
            return Charset.forName("UTF-8");
        }
        catch (IllegalArgumentException exception) {
            logger.log(ILevel.ERROR, exception.getLocalizedMessage(), (Throwable)exception);
            return Charset.forName("UTF-8");
        }
    }
}

