/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import net.anwiba.commons.resource.reference.FileResourceReference;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceFactory;
import net.anwiba.commons.resource.reference.MemoryResourceReference;
import net.anwiba.commons.resource.reference.UriResourceReference;
import net.anwiba.commons.resource.reference.UrlResourceReference;
import net.anwiba.commons.resource.utilities.FileUtilities;
import net.anwiba.commons.resource.utilities.UriUtilities;

public class ResourceReferenceFactory
implements IResourceReferenceFactory {
    @Override
    public IResourceReference create(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        return new FileResourceReference(file);
    }

    @Override
    public IResourceReference create(byte[] buffer, String mimeType) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        return new MemoryResourceReference(buffer, mimeType);
    }

    @Override
    public IResourceReference create(URL url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        return new UrlResourceReference(url);
    }

    @Override
    public IResourceReference create(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        return new UriResourceReference(uri);
    }

    @Override
    public IResourceReference create(String pathString) {
        if (pathString == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (UriUtilities.isFileUrl(pathString)) {
                URL url = new URL(pathString);
                String filePath = url.getFile();
                if (url.getHost() != null && url.getHost().trim().length() > 0) {
                    return new UrlResourceReference(url);
                }
                if (FileUtilities.isAbsoluteWindowsFilePath(filePath)) {
                    String absoluteWindowsFilePath = filePath.startsWith("/") ? filePath : "/" + filePath;
                    URL fileUrl = new URL(MessageFormat.format("file:{0}", absoluteWindowsFilePath));
                    return new UrlResourceReference(fileUrl);
                }
                return new UriResourceReference(new File(filePath).toURI());
            }
            if (UriUtilities.isHttpUrl(pathString)) {
                return new UrlResourceReference(new URL(pathString));
            }
            return new FileResourceReference(new File(pathString));
        }
        catch (MalformedURLException exception) {
            throw new IllegalArgumentException(MessageFormat.format("Found illegal pattern in resource location string: {0}", pathString), exception);
        }
    }

    @Override
    public IResourceReference createTemporaryResourceReference(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        return new ResourceReferenceFactory().create(file);
    }
}

