/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.resource.utilities.StringUtilities;
import net.anwiba.commons.resource.utilities.UriToUrlConverter;

public class UriUtilities {
    private static ILogger logger = Logging.getLogger((String)UriUtilities.class.getName());
    public static final String ERROR_MESSAGE = "Found illegal pattern in resource location string: {0}";
    public static final UriToUrlConverter converter = new UriToUrlConverter();

    public static URI changeUriExtension(URI base, String descriptionFile, String dataFile) {
        try {
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), UriUtilities.createDataFilePath(base.getPath(), descriptionFile, dataFile), base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Unreachable code reached");
        }
    }

    private static String createDataFilePath(String path, String descriptionFile, String dataFile) {
        return String.valueOf(StringUtilities.removeEqualEnd(path, descriptionFile)) + dataFile;
    }

    public static String getNamenFromUriWithoutExtension(URI uri) {
        if (uri == null) {
            return null;
        }
        String name = UriUtilities.getName(uri);
        String subString = StringUtilities.getStringBeforLastChar(name, '.');
        return subString == null ? null : subString.toLowerCase();
    }

    public static String getName(URI uri) {
        if (uri == null) {
            return null;
        }
        return StringUtilities.getStringAfterLastChar(uri.getPath(), '/');
    }

    public static String getQuery(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isOpaque()) {
            return uri.getQuery();
        }
        String string = uri.toString();
        StringBuilder builder = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '?': {
                    builder = new StringBuilder();
                    break;
                }
                default: {
                    if (builder == null) break;
                    builder.append(c);
                }
            }
            ++n2;
        }
        if (builder == null) {
            return null;
        }
        return builder.toString();
    }

    public static String getPath(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isOpaque()) {
            return uri.getPath();
        }
        if (uri.isAbsolute() && uri.getSchemeSpecificPart() != null) {
            UriUtilities.getPath(URI.create(uri.getSchemeSpecificPart()));
        }
        String string = uri.toString();
        StringBuilder builder = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case ':': {
                    builder = new StringBuilder();
                    break;
                }
                case '?': {
                    if (builder == null) {
                        return null;
                    }
                    return builder.toString();
                }
                default: {
                    if (builder == null) break;
                    builder.append(c);
                }
            }
            ++n2;
        }
        if (builder == null) {
            return null;
        }
        return builder.toString();
    }

    public static String getExtension(URI uri) {
        if (uri == null) {
            return null;
        }
        if (!uri.isOpaque()) {
            String subString = StringUtilities.getStringAfterLastChar(uri.getPath(), '.');
            return subString.toLowerCase();
        }
        String string = uri.toString();
        StringBuilder builder = null;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '.': {
                    builder = new StringBuilder();
                    break;
                }
                case '?': {
                    if (builder == null) {
                        return null;
                    }
                    return builder.toString().toLowerCase();
                }
                default: {
                    if (builder == null) break;
                    builder.append(c);
                }
            }
            ++n2;
        }
        if (builder == null) {
            return null;
        }
        return builder.toString().toLowerCase();
    }

    public static URI getParentUri(URI base) {
        if (base == null) {
            return null;
        }
        try {
            String path = UriUtilities.getParentFromPath(base.getPath());
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), path, base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    private static String getParentFromPath(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.equals("/")) {
            return path;
        }
        int index = path.lastIndexOf(47);
        if (index == 0) {
            return "/";
        }
        if (path.endsWith("/")) {
            return UriUtilities.getParentFromPath(path.substring(0, index - 1));
        }
        return path.substring(0, index);
    }

    public static boolean isChild(String path) {
        return path != null && path.trim().length() != 0 && !path.trim().startsWith("/") && !path.trim().startsWith("\\") && !path.contains(":");
    }

    public static URI setPath(URI base, String path) {
        try {
            if (base == null) {
                return new URI(path);
            }
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), path, base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    public static URI concat(URI base, String text) {
        try {
            if (base == null) {
                return new URI(UriUtilities.concat("", text));
            }
            return new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), UriUtilities.concat(base.getPath(), text), base.getQuery(), base.getFragment());
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException("Unreachable code reached", exception);
        }
    }

    private static String concat(String path, String child) {
        if (child == null || child.trim().length() == 0) {
            return path;
        }
        return String.valueOf(path) + "/" + child;
    }

    public static boolean isFileUri(URI uri) {
        return uri != null && (uri.getScheme() == null || uri.getScheme().equalsIgnoreCase("file"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canRead(URI uri) {
        try {
            if (UriUtilities.isFileUri(uri)) {
                return new File(uri).canRead();
            }
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream stream = UriUtilities.openInputStream(uri);){
                return stream != null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean canWrite(URI uri) {
        if (UriUtilities.isFileUri(uri)) {
            return new File(uri).canWrite();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        OutputStream stream = UriUtilities.openOutputStream(uri);
        if (stream != null) {
            stream.close();
        }
        try {
            return true;
        }
        catch (Throwable throwable2) {
            try {
                if (stream != null) {
                    stream.close();
                }
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
    }

    public static boolean exist(URI uri) {
        if (UriUtilities.isFileUri(uri)) {
            return new File(uri).exists();
        }
        try {
            converter.convert(uri).openConnection().connect();
            return true;
        }
        catch (Throwable exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), exception);
            return false;
        }
    }

    public static InputStream openInputStream(URI uri) throws IOException {
        if (UriUtilities.isFileUri(uri)) {
            return new FileInputStream(new File(uri));
        }
        return converter.convert(uri).openStream();
    }

    public static OutputStream openOutputStream(URI uri) throws IOException {
        if (UriUtilities.isFileUri(uri)) {
            return new FileOutputStream(new File(uri));
        }
        try {
            URLConnection connection = converter.convert(uri).openConnection();
            return connection.getOutputStream();
        }
        catch (MalformedURLException exception) {
            throw new IOException(exception);
        }
    }

    public static long getContentLength(URI uri) {
        try {
            if (UriUtilities.isFileUri(uri)) {
                return new File(uri).length();
            }
            URLConnection connection = converter.convert(uri).openConnection();
            return connection.getContentLength();
        }
        catch (IOException exception) {
            logger.log(ILevel.WARNING, exception.getLocalizedMessage());
            return -1L;
        }
    }

    public static void assertMatchUrlPathPattern(String pathString) {
        Pattern pattern = Pattern.compile("^\\p{Alnum}*\\:(/|\\\\){1,2}\\p{Alnum}*");
        Matcher matcher = pattern.matcher(pathString);
        if (!matcher.find()) {
            throw new IllegalArgumentException(MessageFormat.format(ERROR_MESSAGE, pathString));
        }
    }

    public static boolean isFileUrl(String pathString) {
        String string = pathString.toLowerCase();
        if (string.startsWith("file:")) {
            String filePath = pathString.substring(pathString.indexOf(58) + 1, pathString.length());
            if (filePath.startsWith("./") || filePath.startsWith("../")) {
                return true;
            }
            try {
                UriUtilities.assertMatchUrlPathPattern(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHttpUrl(String pathString) {
        String string = pathString.toLowerCase();
        try {
            UriUtilities.assertMatchUrlPathPattern(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return string.startsWith("http://") || string.startsWith("https://");
    }

    public static URI create(String urn) {
        if (UriUtilities.isFileUrl(urn)) {
            return !URI.create(urn).isOpaque() ? URI.create(urn) : new File(URI.create(urn).getSchemeSpecificPart()).toURI();
        }
        if (UriUtilities.isHttpUrl(urn)) {
            return URI.create(urn);
        }
        return new File(urn).toURI();
    }
}

