/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.anwiba.commons.resource.reference.IBackupExecutor;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.ResourceReferenceFactory;
import net.anwiba.commons.resource.reference.ResourceReferenceUtilities;

public final class DefaultBackupExecutor
implements IBackupExecutor {
    @Override
    public IResourceReference backup(IResourceReference resourceReference) throws IOException {
        block6: {
            try {
                if (ResourceReferenceUtilities.isFileSystemResource(resourceReference)) break block6;
                return null;
            }
            catch (URISyntaxException exception) {
                throw new IOException(exception.getLocalizedMessage(), exception);
            }
        }
        File file = ResourceReferenceUtilities.getFile(resourceReference);
        if (file.exists()) {
            File backup = new File(String.valueOf(file.getPath()) + "~");
            Files.move(file.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            if (!backup.exists()) {
                throw new IOException("Coudn't create backup file " + backup);
            }
            if (file.exists()) {
                throw new IOException("Coudn't delete file " + file);
            }
            return new ResourceReferenceFactory().create(backup);
        }
        return null;
    }
}

