/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceVisitor;

public class MemoryResourceReference
implements IResourceReference {
    private final byte[] buffer;
    private final String mimeType;

    public MemoryResourceReference(byte[] buffer, String mimeType) {
        this.buffer = buffer;
        this.mimeType = mimeType;
    }

    @Override
    public <O, E extends Exception> O accept(IResourceReferenceVisitor<O, E> visitor) throws E {
        return visitor.visitMemoryResource(this);
    }

    public int hashCode() {
        return System.identityHashCode(this.buffer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemoryResourceReference)) {
            return false;
        }
        MemoryResourceReference other = (MemoryResourceReference)obj;
        return this.buffer == other.buffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

