/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IRestoreExecutor;
import net.anwiba.commons.resource.reference.ResourceReferenceFactory;
import net.anwiba.commons.resource.reference.ResourceReferenceUtilities;

public final class DefaultRestoreExecutor
implements IRestoreExecutor {
    @Override
    public IResourceReference restore(IResourceReference resourceReference) throws IOException {
        try {
            if (!ResourceReferenceUtilities.isFileSystemResource(resourceReference)) {
                throw new IOException("Unsupported resource");
            }
            File file = ResourceReferenceUtilities.getFile(resourceReference);
            File backup = new File(String.valueOf(file.getPath()) + "~");
            if (backup.exists()) {
                Files.copy(backup.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                if (!file.exists()) {
                    throw new IOException("Coudn't restore file " + file);
                }
                return new ResourceReferenceFactory().create(backup);
            }
            return null;
        }
        catch (URISyntaxException exception) {
            throw new IOException(exception.getLocalizedMessage(), exception);
        }
    }
}

