/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.anwiba.commons.resource.reference.IBackupExecutor;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceHandler;

public final class DefaultBackupExecutor
implements IBackupExecutor {
    private final IResourceReferenceHandler referenceHandler;

    public DefaultBackupExecutor(IResourceReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    @Override
    public IResourceReference backup(IResourceReference resourceReference) throws IOException {
        if (!this.referenceHandler.exsits(resourceReference)) {
            return null;
        }
        try {
            File file = this.referenceHandler.getFile(resourceReference);
            if (file.exists()) {
                File backup = new File(String.valueOf(file.getPath()) + "~");
                Files.move(file.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                if (!backup.exists()) {
                    throw new IOException("Coudn't create backup file " + backup);
                }
                if (file.exists()) {
                    throw new IOException("Coudn't delete file " + file);
                }
            }
            return null;
        }
        catch (URISyntaxException exception) {
            throw new IOException(exception.getLocalizedMessage(), exception);
        }
    }
}

