/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reflaction;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import net.anwiba.commons.lang.functional.IBiFunction;

public class ResourceUtilities {
    public static URL getUrl(IBiFunction<Class, String, URL, IOException> helper, Class clazz, String resourceUrl) throws IOException {
        if (resourceUrl.startsWith("file:") || resourceUrl.startsWith("http:") || resourceUrl.startsWith("https:")) {
            return new URL(resourceUrl);
        }
        URL resource = (URL)helper.execute((Object)clazz, (Object)resourceUrl);
        if (resource != null) {
            return resource;
        }
        String absoluteResourceUrl = ResourceUtilities.createResourceUrl(ResourceUtilities.createRootPath(clazz), resourceUrl);
        resource = (URL)helper.execute((Object)clazz, (Object)absoluteResourceUrl);
        if (resource != null) {
            return resource;
        }
        return ResourceUtilities.getUrl(clazz, absoluteResourceUrl);
    }

    private static String createRootPath(Class<?> clazz) {
        return clazz.getPackage().getName().replace('.', '/');
    }

    private static String createResourceUrl(String pathRoot, String path) {
        String resource = MessageFormat.format("{0}/{1}", pathRoot, path);
        return ResourceUtilities.toAbsolutePathIfNot(Paths.get(resource, new String[0]).normalize().toString());
    }

    public static URL getUrl(Class clazz, String resourceUrl) throws IOException {
        if (resourceUrl.startsWith("file:") || resourceUrl.startsWith("http:") || resourceUrl.startsWith("https:")) {
            return new URL(resourceUrl);
        }
        URL resource = null;
        resource = ResourceUtilities.getByPath(clazz, ResourceUtilities.toRelativePathIfNot(clazz, resourceUrl));
        if (resource != null) {
            return resource;
        }
        resource = ResourceUtilities.getByPath(clazz, ResourceUtilities.toAbsolutePathIfNot(Paths.get(resourceUrl, new String[0]).normalize().toString()));
        if (resource != null) {
            return resource;
        }
        resource = ResourceUtilities.getByPath(clazz, ResourceUtilities.toAbsolutePathIfNot(resourceUrl));
        if (resource != null) {
            return resource;
        }
        throw new FileNotFoundException(resourceUrl + " on " + clazz.getName());
    }

    private static String toRelativePathIfNot(Class clazz, String resourceUrl) {
        Path packagePath;
        Path resourcePath = Paths.get(resourceUrl, new String[0]).normalize();
        if (resourcePath.startsWith(packagePath = Paths.get("", clazz.getPackage().getName().split("\\.")))) {
            return packagePath.relativize(resourcePath).normalize().toString();
        }
        return ResourceUtilities.isAbsolute(resourceUrl) ? resourceUrl.substring(1) : resourceUrl;
    }

    private static String toAbsolutePathIfNot(String resourcePath) {
        return ResourceUtilities.isAbsolute(resourcePath) ? resourcePath : "/" + resourcePath;
    }

    private static boolean isAbsolute(String value) {
        return value.startsWith("/");
    }

    private static URL getByPath(Class clazz, String resourcePath) {
        URL resource = null;
        resource = clazz.getResource(resourcePath);
        if (resource != null) {
            return resource;
        }
        resource = clazz.getClassLoader().getResource(resourcePath);
        if (resource != null) {
            return resource;
        }
        resource = ClassLoader.getPlatformClassLoader().getResource(resourcePath);
        if (resource != null) {
            return resource;
        }
        resource = ClassLoader.getSystemClassLoader().getResource(resourcePath);
        if (resource != null) {
            return resource;
        }
        return null;
    }
}

