/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reflaction;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.ResourceReferenceHandler;
import net.anwiba.commons.resource.reflaction.AbstractResourceProvider;
import net.anwiba.commons.resource.reflaction.IByteArrayResourceProvider;

public abstract class AbstractTextResourceProvider
extends AbstractResourceProvider
implements IByteArrayResourceProvider {
    private final IResourceReferenceHandler resourceReferenceHandler = new ResourceReferenceHandler();

    public AbstractTextResourceProvider(IResourceReference resourceReference) {
        super(resourceReference);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IByteArrayResourceProvider)) {
            return false;
        }
        IByteArrayResourceProvider other = (IByteArrayResourceProvider)obj;
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    private byte[] read() {
        byte[] byArray;
        block9: {
            InputStream inputStream = this.resourceReferenceHandler.openInputStream(this.getResource());
            try {
                byte[] array = new byte[1024];
                byte[] buffer = new byte[]{};
                int length = 0;
                while ((length = inputStream.read(array)) > -1) {
                    buffer = this.concat(buffer, array, length);
                }
                byArray = buffer;
                if (inputStream == null) break block9;
            }
            catch (Throwable array) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable buffer) {
                            array.addSuppressed(buffer);
                        }
                    }
                    throw array;
                }
                catch (IOException exception) {
                    ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                    PrintStream outputStream = new PrintStream(arrayOutputStream);
                    exception.printStackTrace(outputStream);
                    return arrayOutputStream.toByteArray();
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private byte[] concat(byte[] buffer, byte[] array, int length) {
        byte[] result = new byte[buffer.length + length];
        System.arraycopy(buffer, 0, result, 0, buffer.length);
        System.arraycopy(array, 0, result, buffer.length, length);
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toString("UTF-8");
    }

    @Override
    public String toString(String encoding) {
        byte[] buffer = this.read();
        return Charset.forName(encoding).decode(ByteBuffer.wrap(buffer, 0, buffer.length)).toString();
    }

    public static String getExtention() {
        return "txt";
    }

    @Override
    public byte[] getBytes() {
        return this.read();
    }
}

