/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reflaction;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.reference.ResourceReferenceFactory;
import net.anwiba.commons.reference.ResourceReferenceHandler;
import net.anwiba.commons.reference.ResourceReferenceUtilities;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;
import net.anwiba.commons.resource.reflaction.ByteArrayResourceProvider;
import net.anwiba.commons.resource.reflaction.IByteArrayResourceProvider;
import net.anwiba.commons.resource.reflaction.IResourceProvider;

public final class FieldValueFactory {
    private static ILogger logger = Logging.getLogger((String)FieldValueFactory.class.getName());
    private static final ResourceReferenceFactory resourceReferenceFactory = new ResourceReferenceFactory();
    private final IResourceReferenceHandler resourceReferenceHandler = new ResourceReferenceHandler();

    public Object create(Class<?> type, boolean isStatic, URL url, Charset charset) throws InvocationTargetException {
        try {
            Class<?> clazz = Class.forName(type.getName());
            if (IResourceProvider.class.isAssignableFrom(clazz)) {
                IResourceReference resourceReference = this.createResource(isStatic, url);
                return this.createResourceProvider(clazz, resourceReference);
            }
            if (IResourceReference.class.equals(clazz)) {
                return this.createResource(isStatic, url);
            }
            byte[] buffer = this.read(resourceReferenceFactory.create(url));
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(buffer, 0, buffer.length));
            if (type.isArray()) {
                return this.createArray(charBuffer.toString());
            }
            return charBuffer.toString();
        }
        catch (ClassNotFoundException | CreationException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private IResourceReference createResource(boolean isStatic, URL resourceUrl) throws CreationException {
        if (isStatic) {
            IResourceReference resourceReference = resourceReferenceFactory.create(resourceUrl);
            byte[] buffer = this.read(resourceReference);
            return resourceReferenceFactory.create(buffer, this.resourceReferenceHandler.getContentType(resourceReference), Charset.defaultCharset().name());
        }
        return resourceReferenceFactory.create(resourceUrl);
    }

    private Object createResourceProvider(Class<? extends IResourceProvider> clazz, IResourceReference resourceReference) throws InvocationTargetException {
        if (clazz.equals(IByteArrayResourceProvider.class)) {
            return new ByteArrayResourceProvider(resourceReference);
        }
        ReflectionConstructorInvoker invoker = new ReflectionConstructorInvoker(clazz, new Class[]{IResourceReference.class});
        return invoker.invoke(new Object[]{resourceReference});
    }

    private String[] createArray(String fieldValue) {
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(fieldValue.replace("\r\n", "\n").replace("\r", "\n"), "\n");
        while (tokenizer.hasMoreElements()) {
            String nextToken = tokenizer.nextToken().trim();
            if (nextToken == null || nextToken.isEmpty()) continue;
            values.add(nextToken);
        }
        return values.toArray(new String[values.size()]);
    }

    private byte[] read(IResourceReference resourceReference) {
        byte[] byArray;
        block9: {
            if (resourceReference == null) {
                String message = "Error loading text resource, resource value is not defined";
                logger.log(ILevel.ERROR, "Error loading text resource, resource value is not defined");
                throw new RuntimeException("Error loading text resource, resource value is not defined");
            }
            InputStream input = this.resourceReferenceHandler.openInputStream(resourceReference);
            try {
                byArray = this.read(input);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = MessageFormat.format("Error loading text resource ''{0}''", ResourceReferenceUtilities.toString((IResourceReference)resourceReference));
                    logger.log(ILevel.ERROR, message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
            }
            input.close();
        }
        return byArray;
    }

    private byte[] read(InputStream inputStream) throws IOException {
        byte[] array = new byte[1024];
        byte[] buffer = new byte[]{};
        int length = 0;
        while ((length = inputStream.read(array)) > -1) {
            buffer = this.concat(buffer, array, length);
        }
        return buffer;
    }

    private byte[] concat(byte[] buffer, byte[] array, int length) {
        byte[] result = new byte[buffer.length + length];
        System.arraycopy(buffer, 0, result, 0, buffer.length);
        System.arraycopy(array, 0, result, buffer.length, length);
        return result;
    }
}

