/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.model.BooleanModel;
import net.anwiba.commons.model.IBooleanDistributor;
import net.anwiba.commons.model.IBooleanModel;
import net.anwiba.commons.swing.action.AbstractCustomizedAction;
import net.anwiba.commons.swing.action.IActionConfiguration;
import net.anwiba.commons.swing.action.IActionProcedure;
import net.anwiba.commons.swing.dialog.MessageDialogLauncher;

public class ConfigurableAction
extends AbstractCustomizedAction {
    private static ILogger logger = Logging.getLogger((String)ConfigurableAction.class.getName());
    private final IActionProcedure closure;
    private final IBooleanModel internalEnabledModel = new BooleanModel(true);

    public ConfigurableAction(IActionConfiguration configuration) {
        super(configuration.getCustomization());
        IBooleanDistributor enabledDistributor = configuration.getEnabledDistributor().and((IBooleanDistributor)this.internalEnabledModel, new IBooleanDistributor[0]);
        enabledDistributor.addChangeListener(() -> ConfigurableAction.super.setEnabled(enabledDistributor.get()));
        super.setEnabled(enabledDistributor.get());
        this.closure = configuration.getProcedure();
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.internalEnabledModel.set(newValue);
    }

    @Override
    protected void execute(Component componment, ActionEvent event) {
        try {
            this.closure.execute(componment);
        }
        catch (Exception exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            new MessageDialogLauncher().text(exception.getMessage()).error().throwable(exception).launch(componment);
        }
    }
}

