/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.combobox;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.anwiba.commons.model.IObjectModel;
import net.anwiba.commons.swing.combobox.IComboBoxModel;
import net.anwiba.commons.swing.component.IComponentProvider;
import net.anwiba.commons.swing.list.IObjectListConfiguration;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.ui.ObjectUiListCellRenderer;

public class ObjectComboBoxComponent<T>
implements IComponentProvider {
    private final JComponent component;
    private IObjectModel<T> objectModel;

    public ObjectComboBoxComponent(IComboBoxModel<T> listModel) {
        this(new ObjectListConfigurationBuilder().build(), listModel);
    }

    public ObjectComboBoxComponent(IObjectListConfiguration<T> configuration, IComboBoxModel<T> listModel) {
        this.objectModel = listModel;
        JComboBox<T> list = new JComboBox<T>(listModel);
        list.setRenderer(new ObjectUiListCellRenderer<T>(configuration.getObjectUiCellRendererConfiguration(), configuration.getObjectUi()));
        list.setPrototypeDisplayValue(configuration.getPrototype());
        list.setMaximumRowCount(configuration.getVisibleRowCount());
        this.component = list;
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    public IObjectModel<T> getSelectionModel() {
        return this.objectModel;
    }
}

