/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.combobox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.border.Border;
import net.anwiba.commons.swing.combobox.IComboBoxModel;
import net.anwiba.commons.swing.combobox.ObjectComboBoxComponent;
import net.anwiba.commons.swing.combobox.ObjectComboBoxComponentModel;
import net.anwiba.commons.swing.list.ObjectListConfigurationBuilder;
import net.anwiba.commons.swing.ui.IObjectUi;

public class ObjectComboBoxComponentBuilder<T> {
    final ObjectListConfigurationBuilder<T> configurationBuilder = new ObjectListConfigurationBuilder();
    private IComboBoxModel<T> model;

    public ObjectComboBoxComponentBuilder<T> setObjectUi(IObjectUi<T> objectUi) {
        this.configurationBuilder.setObjectUi(objectUi);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setPrototype(T prototype) {
        this.configurationBuilder.setPrototype(prototype);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setSingleSelectionMode() {
        this.configurationBuilder.setSingleSelectionMode();
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setSingleIntervalSelectionMode() {
        this.configurationBuilder.setSingleIntervalSelectionMode();
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setMultiSelectionMode() {
        this.configurationBuilder.setMultiSelectionMode();
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setIconTextGap(int iconTextGap) {
        this.configurationBuilder.setIconTextGap(iconTextGap);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setVerticalTextPosition(int verticalTextPosition) {
        this.configurationBuilder.setVerticalTextPosition(verticalTextPosition);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setHorizontalTextPosition(int horizontalTextPosition) {
        this.configurationBuilder.setHorizontalTextPosition(horizontalTextPosition);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setHorizontalAlignment(int horizontalAlignment) {
        this.configurationBuilder.setHorizontalAlignment(horizontalAlignment);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setBorder(Border border) {
        this.configurationBuilder.setBorder(border);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setVisibleRowCount(int visibleRowCount) {
        this.configurationBuilder.setVisibleRowCount(visibleRowCount);
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setModel(IComboBoxModel<T> model) {
        this.model = model;
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setValues(T[] values) {
        this.setValues(Arrays.asList(values));
        return this;
    }

    public ObjectComboBoxComponentBuilder<T> setValues(List<T> values) {
        this.model = new ObjectComboBoxComponentModel<T>(values);
        return this;
    }

    public ObjectComboBoxComponent<T> build() {
        this.model = Optional.ofNullable(this.model).orElseGet(() -> new ObjectComboBoxComponentModel(new ArrayList()));
        this.model.setSelectedItem(null);
        return new ObjectComboBoxComponent<T>(this.configurationBuilder.build(), this.model);
    }
}

