/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.anwiba.commons.swing.component.GridBagLayoutComponent;
import net.anwiba.commons.swing.component.IGridBagLayoutComponent;

public class GridBagLayoutComponentBuilder {
    private static final int UNDEFIND_ANCHOR = -1;
    private final List<IGridBagLayoutComponent> components = new ArrayList<IGridBagLayoutComponent>(10);
    private int row = 0;
    private int column = -1;
    private int maximunsNumberOfColumns = -1;
    private Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private final Insets insets = new Insets(4, 4, 0, 0);

    public GridBagLayoutComponentBuilder label(String text) {
        this.newline();
        JLabel label = new JLabel(String.valueOf(text) + (text.isEmpty() ? "" : ":"));
        label.setVerticalTextPosition(1);
        label.setVerticalAlignment(1);
        label.setHorizontalTextPosition(2);
        label.setHorizontalAlignment(2);
        this.components.add(new GridBagLayoutComponent(label, ++this.column, this.row, 1, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder add(JComponent component) {
        this.components.add(new GridBagLayoutComponent(component, ++this.column, this.row, 1, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder add(JComponent component, int with) {
        int componentColumn = this.column + 1;
        this.column += with;
        this.components.add(new GridBagLayoutComponent(component, componentColumn, this.row, with, 1, -1));
        return this;
    }

    public GridBagLayoutComponentBuilder newline() {
        this.maximunsNumberOfColumns = Math.max(this.maximunsNumberOfColumns, this.column);
        this.column = -1;
        ++this.row;
        return this;
    }

    public JComponent build() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBorder(this.border);
        for (IGridBagLayoutComponent component : this.components) {
            contentPanel.add((Component)component.getComponent(), component.getConstraints(this.insets));
        }
        return contentPanel;
    }

    public GridBagLayoutComponentBuilder emptyLine() {
        if (this.column > -1) {
            this.newline();
        }
        this.components.add(new GridBagLayoutComponent(new JLabel(" "), ++this.column, this.row, 1, 1, -1));
        this.newline();
        return this;
    }

    public GridBagLayoutComponentBuilder setBorder(Border border) {
        this.border = border;
        return this;
    }
}

